/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.mixin;

import appeng.util.ReadableNumberConverter;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={GuiGraphics.class}, remap=false)
public class RestockRender {
    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;II)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderGuiItemOverlay(Font font, ItemStack stack, int x, int y, CallbackInfo ci) {
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().player.isCreative()) {
            return;
        }
        CraftingTerminalHandler handler = CraftingTerminalHandler.getCraftingTerminalHandler((Player)Minecraft.getInstance().player);
        if (stack.getCount() == 1 || !handler.isRestockAble(stack) || !ItemWT.getBoolean(handler.getCraftingTerminal(), "restock")) {
            return;
        }
        ((GuiGraphics)this).renderItemDecorations(font, stack, x, y, ReadableNumberConverter.format((long)handler.getAccessibleAmount(stack), (int)3));
        ci.cancel();
    }
}

