/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.networking;

import appeng.menu.AEBaseMenu;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuHostLocator;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.networking.AE2wtlibPacket;
import de.mari_023.ae2wtlib.wut.ItemWUT;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public record CycleTerminalPacket(boolean isRightClick) implements AE2wtlibPacket
{
    public static final ResourceLocation ID = AE2wtlib.id("cycle_terminal");

    public CycleTerminalPacket(FriendlyByteBuf buf) {
        this(buf.readBoolean());
    }

    @Override
    public void processPacketData(Player player) {
        AbstractContainerMenu containerMenu = player.containerMenu;
        if (!(containerMenu instanceof AEBaseMenu)) {
            return;
        }
        AEBaseMenu aeMenu = (AEBaseMenu)containerMenu;
        MenuHostLocator menuHostLocator = aeMenu.getLocator();
        if (!(menuHostLocator instanceof ItemMenuHostLocator)) {
            return;
        }
        ItemMenuHostLocator locator = (ItemMenuHostLocator)menuHostLocator;
        ItemStack item = locator.locateItem(player);
        if (!(item.getItem() instanceof ItemWUT)) {
            return;
        }
        WUTHandler.cycle(player, locator, item, this.isRightClick());
        WUTHandler.open(player, locator, true);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isRightClick());
    }

    public ResourceLocation id() {
        return ID;
    }
}

