/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.api.inventories.InternalInventory;
import appeng.menu.slot.AppEngSlot;
import com.mojang.datafixers.util.Pair;
import de.mari_023.ae2wtlib.terminal.WrappedPlayerInventory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ArmorSlot
extends AppEngSlot {
    private final Inventory playerInventory;
    private final Armor armor;

    public ArmorSlot(Inventory playerInventory, Armor armor) {
        super((InternalInventory)new WrappedPlayerInventory(playerInventory), armor.invSlot);
        this.playerInventory = playerInventory;
        this.armor = armor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)this.armor.background);
    }

    public boolean mayPlace(ItemStack stack) {
        ArmorItem aItem;
        Item item;
        return this.armor == Armor.OFFHAND || this.playerInventory.canPlaceItem(this.armor.invSlot, stack) && (item = stack.getItem()) instanceof ArmorItem && (aItem = (ArmorItem)item).getEquipmentSlot().equals((Object)this.armor.equipmentSlot);
    }

    public static enum Armor {
        FEET(EquipmentSlot.FEET, 36, InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS),
        LEGS(EquipmentSlot.LEGS, 37, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS),
        CHEST(EquipmentSlot.CHEST, 38, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE),
        HEAD(EquipmentSlot.HEAD, 39, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET),
        OFFHAND(EquipmentSlot.HEAD, 40, InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);

        public final EquipmentSlot equipmentSlot;
        public final int invSlot;
        public final ResourceLocation background;

        private Armor(EquipmentSlot equipmentSlot, int invSlot, ResourceLocation background) {
            this.equipmentSlot = equipmentSlot;
            this.invSlot = invSlot;
            this.background = background;
        }
    }

    public static class DisabledOffhandSlot
    extends ArmorSlot {
        public DisabledOffhandSlot(Inventory playerInventory) {
            super(playerInventory, Armor.OFFHAND);
        }

        @Override
        public boolean mayPlace(ItemStack stack) {
            return false;
        }

        public boolean mayPickup(Player player) {
            return false;
        }
    }
}

