/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.client.gui.widgets.ITooltip;
import appeng.core.AppEng;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ItemButton
extends Button
implements ITooltip {
    private final ResourceLocation texture;
    public static final ResourceLocation TEXTURE_STATES = AppEng.makeId((String)"textures/guis/states.png");

    public ItemButton(Button.OnPress onPress, ResourceLocation texture) {
        super(0, 0, 16, 16, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.texture = texture;
    }

    public void setVisibility(boolean vis) {
        this.visible = vis;
        this.active = vis;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (!this.visible) {
            return;
        }
        guiGraphics.pose().pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        if (this.isFocused()) {
            guiGraphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + 17, this.getY() + 17, -1);
        }
        guiGraphics.blit(TEXTURE_STATES, this.getX(), this.getY(), 16, 16, 240.0f, 240.0f, 16, 16, 256, 256);
        if (this.active) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        guiGraphics.blit(this.texture, this.getX(), this.getY(), 16, 16, 0.0f, 0.0f, 512, 512, 512, 512);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().popPose();
    }

    @NotNull
    public List<Component> getTooltipMessage() {
        return Collections.singletonList(this.getMessage());
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.getX(), this.getY(), 16, 16);
    }

    public boolean isTooltipAreaVisible() {
        return this.visible;
    }
}

