/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.core.AEConfig;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.menu.MenuOpener;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import de.mari_023.ae2wtlib.AE2wtlibItems;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class ItemWT
extends WirelessTerminalItem
implements ICurioItem {
    public ItemWT() {
        super(AEConfig.instance().getWirelessTerminalBattery(), new Item.Properties().stacksTo(1));
    }

    public boolean open(Player player, ItemMenuHostLocator locator, boolean returningFromSubmenu) {
        return MenuOpener.open(this.getMenuType(locator, player), (Player)player, (MenuHostLocator)locator, (boolean)returningFromSubmenu);
    }

    public boolean tryOpen(Player player, ItemMenuHostLocator locator, boolean returningFromSubmenu) {
        if (this.checkPreconditions(locator.locateItem(player))) {
            return this.open(player, locator, returningFromSubmenu);
        }
        return false;
    }

    public abstract MenuType<?> getMenuType(ItemMenuHostLocator var1, Player var2);

    protected boolean checkPreconditions(ItemStack item) {
        return !item.isEmpty() && (item.getItem() == this || item.getItem() == AE2wtlibItems.instance().UNIVERSAL_TERMINAL);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack is = player.getItemInHand(hand);
        if (this.checkPreconditions(is)) {
            if (!level.isClientSide()) {
                this.open(player, MenuLocators.forHand((Player)player, (InteractionHand)hand), false);
            }
            return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)is);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)is);
    }

    public WirelessTerminalMenuHost<?> getMenuHost(Player player, ItemMenuHostLocator locator, @Nullable BlockHitResult hitResult) {
        return WUTHandler.wirelessTerminals.get(WUTHandler.getCurrentTerminal(locator.locateItem(player))).wTMenuHostFactory().create(this, player, locator, (p, subMenu) -> this.tryOpen(player, locator, true));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        this.inventoryTick(stack, slotContext.entity().level(), (Entity)slotContext.entity(), 0, false);
    }

    public static boolean getBoolean(ItemStack hostItem, String key) {
        if (!(hostItem.getItem() instanceof ItemWT)) {
            return false;
        }
        return hostItem.getOrCreateTag().getBoolean(key);
    }

    public static void setBoolean(ItemStack hostItem, boolean b, String key) {
        if (!(hostItem.getItem() instanceof ItemWT)) {
            return;
        }
        hostItem.getOrCreateTag().putBoolean(key, b);
    }
}

