/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct;

import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.Icon;
import appeng.client.gui.me.items.CraftingTermScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.BackgroundPanel;
import appeng.client.gui.widgets.IconButton;
import appeng.menu.me.items.CraftingTermMenu;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.TextConstants;
import de.mari_023.ae2wtlib.terminal.ItemButton;
import de.mari_023.ae2wtlib.wct.PlayerEntityWidget;
import de.mari_023.ae2wtlib.wct.WCTMenu;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetMode;
import de.mari_023.ae2wtlib.wut.CycleTerminalButton;
import de.mari_023.ae2wtlib.wut.IUniversalTerminalCapable;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;

public class WCTScreen
extends CraftingTermScreen<WCTMenu>
implements IUniversalTerminalCapable {
    private final ItemButton magnetCardToggleButton;
    private final ItemButton magnetCardMenuButton;

    public WCTScreen(WCTMenu container, Inventory playerInventory, Component title, ScreenStyle style) {
        super((CraftingTermMenu)container, playerInventory, title, style);
        if (((WCTMenu)this.getMenu()).isWUT()) {
            this.addToLeftToolbar(new CycleTerminalButton(btn -> this.cycleTerminal()));
        }
        this.magnetCardToggleButton = new ItemButton(btn -> this.setMagnetMode(), AE2wtlib.id("textures/item/magnet_card.png"));
        this.addToLeftToolbar(this.magnetCardToggleButton);
        this.magnetCardMenuButton = new ItemButton(btn -> ((WCTMenu)this.getMenu()).openMagnetMenu(), AE2wtlib.id("textures/item/magnet_card.png"));
        this.addToLeftToolbar(this.magnetCardMenuButton);
        this.magnetCardMenuButton.setMessage(TextConstants.MAGNET_FILTER);
        IconButton deleteButton = new IconButton(btn -> ((WCTMenu)this.getMenu()).openTrashMenu()){

            protected Icon getIcon() {
                return Icon.CONDENSER_OUTPUT_TRASH;
            }
        };
        this.addToLeftToolbar((Button)deleteButton);
        deleteButton.setMessage((Component)TextConstants.TRASH);
        this.widgets.add("player", (AbstractWidget)new PlayerEntityWidget((LivingEntity)Objects.requireNonNull(Minecraft.getInstance().player)));
        this.widgets.add("singularityBackground", (ICompositeWidget)new BackgroundPanel(style.getImage("singularityBackground")));
    }

    private void setMagnetMode() {
        if (this.isHandlingRightClick()) {
            switch (((WCTMenu)this.getMenu()).getMagnetSettings().magnetMode) {
                case OFF: {
                    ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.PICKUP_ME);
                    break;
                }
                case PICKUP_INVENTORY: {
                    ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.OFF);
                    break;
                }
                case PICKUP_ME: {
                    ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.PICKUP_INVENTORY);
                }
            }
            return;
        }
        switch (((WCTMenu)this.getMenu()).getMagnetSettings().magnetMode) {
            case OFF: {
                ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.PICKUP_INVENTORY);
                break;
            }
            case PICKUP_INVENTORY: {
                ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.PICKUP_ME);
                break;
            }
            case PICKUP_ME: {
                ((WCTMenu)this.getMenu()).setMagnetMode(MagnetMode.OFF);
            }
        }
    }

    private void setMagnetModeText() {
        switch (((WCTMenu)this.getMenu()).getMagnetSettings().magnetMode) {
            case INVALID: 
            case NO_CARD: {
                this.magnetCardToggleButton.setVisibility(false);
                this.magnetCardMenuButton.setVisibility(false);
                break;
            }
            case OFF: {
                this.magnetCardToggleButton.setVisibility(true);
                this.magnetCardMenuButton.setVisibility(true);
                this.magnetCardToggleButton.setMessage((Component)TextConstants.MAGNETCARD_OFF);
                break;
            }
            case PICKUP_INVENTORY: {
                this.magnetCardToggleButton.setVisibility(true);
                this.magnetCardMenuButton.setVisibility(true);
                this.magnetCardToggleButton.setMessage((Component)TextConstants.MAGNETCARD_INVENTORY);
                break;
            }
            case PICKUP_ME: {
                this.magnetCardToggleButton.setVisibility(true);
                this.magnetCardMenuButton.setVisibility(true);
                this.magnetCardToggleButton.setMessage((Component)TextConstants.MAGNETCARD_ME);
            }
        }
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.setMagnetModeText();
    }
}

