/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct.magnet_card;

import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.stacks.AEKeyType;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.IPartitionList;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import net.minecraft.nbt.CompoundTag;

public class MagnetHost {
    public final ConfigInventory pickupConfig = ConfigInventory.configTypes((int)27).changeListener(this::updatePickupFilter).supportedTypes(AEKeyType.items(), new AEKeyType[0]).build();
    public final ConfigInventory insertConfig = ConfigInventory.configTypes((int)27).changeListener(this::updateInsertFilter).supportedTypes(AEKeyType.items(), new AEKeyType[0]).build();
    private IPartitionList pickupFilter = this.createFilter(this.pickupConfig);
    private IPartitionList insertFilter = this.createFilter(this.insertConfig);
    private IncludeExclude pickupMode;
    private IncludeExclude insertMode;
    private final CraftingTerminalHandler ctHandler;

    public MagnetHost(CraftingTerminalHandler ctHandler) {
        this.ctHandler = ctHandler;
        CompoundTag tag = this.getTag();
        this.pickupConfig.readFromChildTag(tag, "pickupConfig");
        this.insertConfig.readFromChildTag(tag, "insertConfig");
        this.pickupMode = this.booleanToIncludeExclude(tag.getBoolean("pickupMode"));
        this.insertMode = this.booleanToIncludeExclude(tag.getBoolean("insertMode"));
    }

    private IPartitionList createFilter(ConfigInventory config) {
        IPartitionList.Builder builder = IPartitionList.builder();
        builder.fuzzyMode(FuzzyMode.IGNORE_ALL);
        for (int x = 0; x < config.size(); ++x) {
            builder.add(config.getKey(x));
        }
        return builder.build();
    }

    private void updatePickupFilter() {
        this.pickupFilter = this.createFilter(this.pickupConfig);
        this.pickupConfig.writeToChildTag(this.ctHandler.getCraftingTerminal().getOrCreateTag(), "pickupConfig");
    }

    private void updateInsertFilter() {
        this.insertFilter = this.createFilter(this.insertConfig);
        this.insertConfig.writeToChildTag(this.ctHandler.getCraftingTerminal().getOrCreateTag(), "insertConfig");
    }

    public IPartitionList getPickupFilter() {
        return this.pickupFilter;
    }

    public IncludeExclude getPickupMode() {
        return this.pickupMode;
    }

    public void togglePickupMode() {
        this.pickupMode = this.toggle(this.pickupMode);
        this.getTag().putBoolean("pickupMode", this.includeExcludeToBoolean(this.pickupMode));
    }

    public IPartitionList getInsertFilter() {
        return this.insertFilter;
    }

    public IncludeExclude getInsertMode() {
        return this.insertMode;
    }

    public void toggleInsertMode() {
        this.insertMode = this.toggle(this.insertMode);
        this.getTag().putBoolean("insertMode", this.includeExcludeToBoolean(this.insertMode));
    }

    public CompoundTag getTag() {
        return this.ctHandler.getCraftingTerminal().getOrCreateTag();
    }

    public IncludeExclude toggle(IncludeExclude includeExclude) {
        return switch (includeExclude) {
            default -> throw new IncompatibleClassChangeError();
            case IncludeExclude.WHITELIST -> IncludeExclude.BLACKLIST;
            case IncludeExclude.BLACKLIST -> IncludeExclude.WHITELIST;
        };
    }

    public boolean includeExcludeToBoolean(IncludeExclude includeExclude) {
        return switch (includeExclude) {
            default -> throw new IncompatibleClassChangeError();
            case IncludeExclude.WHITELIST -> true;
            case IncludeExclude.BLACKLIST -> false;
        };
    }

    public IncludeExclude booleanToIncludeExclude(boolean b) {
        return b ? IncludeExclude.WHITELIST : IncludeExclude.BLACKLIST;
    }

    public void copyUp() {
        this.pickupConfig.readFromChildTag(this.getTag(), "insertConfig");
    }

    public void copyDown() {
        this.insertConfig.readFromChildTag(this.getTag(), "pickupConfig");
    }

    public void switchInsertPickup() {
        this.pickupConfig.writeToChildTag(this.ctHandler.getCraftingTerminal().getOrCreateTag(), "insertConfig");
        this.insertConfig.writeToChildTag(this.ctHandler.getCraftingTerminal().getOrCreateTag(), "pickupConfig");
        this.pickupConfig.readFromChildTag(this.getTag(), "pickupConfig");
        this.insertConfig.readFromChildTag(this.getTag(), "insertConfig");
    }
}

