/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut;

import appeng.client.gui.widgets.ITooltip;
import appeng.core.AppEng;
import com.mojang.blaze3d.systems.RenderSystem;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.TextConstants;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CycleTerminalButton
extends Button
implements ITooltip {
    public static final ResourceLocation TEXTURE_STATES = AppEng.makeId((String)"textures/guis/states.png");
    public static final ResourceLocation nextTerminal = AE2wtlib.id("textures/item/wireless_universal_terminal.png");

    public CycleTerminalButton(Button.OnPress onPress) {
        super(0, 0, 16, 16, (Component)Component.empty(), onPress, Button.DEFAULT_NARRATION);
        this.visible = true;
        this.active = true;
    }

    @NotNull
    public List<Component> getTooltipMessage() {
        return Collections.singletonList(TextConstants.CYCLE_TOOLTIP);
    }

    public Rect2i getTooltipArea() {
        return new Rect2i(this.getX(), this.getY(), 16, 16);
    }

    public boolean isTooltipAreaVisible() {
        return true;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        if (!this.visible) {
            return;
        }
        guiGraphics.pose().pushPose();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        if (this.isFocused()) {
            guiGraphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.width + 1, this.getY() + this.height + 1, -1);
        }
        guiGraphics.blit(TEXTURE_STATES, this.getX(), this.getY(), 240, 240, 16, 16);
        if (this.active) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        guiGraphics.blit(nextTerminal, this.getX() + 1, this.getY() + 1, 14, 14, 0.0f, 0.0f, 512, 512, 512, 512);
        guiGraphics.pose().popPose();
    }
}

