/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut;

import appeng.api.config.Actionable;
import appeng.api.features.HotkeyAction;
import appeng.hotkeys.HotkeyActions;
import appeng.integration.modules.curios.CuriosIntegration;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuLocators;
import de.mari_023.ae2wtlib.AE2wtlibItems;
import de.mari_023.ae2wtlib.TextConstants;
import de.mari_023.ae2wtlib.hotkeys.Ae2WTLibLocatingService;
import de.mari_023.ae2wtlib.networking.UpdateWUTPackage;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wut.ItemWUT;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class WUTHandler {
    public static final Map<String, WTDefinition> wirelessTerminals = new HashMap<String, WTDefinition>();
    public static final List<String> terminalNames = new ArrayList<String>();

    public static String getCurrentTerminal(ItemStack terminal) {
        if (terminal.getItem() instanceof ItemWUT) {
            String currentTerminal = terminal.getOrCreateTag().getString("currentTerminal");
            if (wirelessTerminals.containsKey(currentTerminal)) {
                return currentTerminal;
            }
            for (String term : terminalNames) {
                if (!terminal.getOrCreateTag().getBoolean(term)) continue;
                currentTerminal = term;
                terminal.getOrCreateTag().putString("currentTerminal", currentTerminal);
                break;
            }
            return currentTerminal;
        }
        for (Map.Entry<String, WTDefinition> entry : wirelessTerminals.entrySet()) {
            if (!terminal.getItem().equals((Object)entry.getValue().item())) continue;
            return entry.getKey();
        }
        return "";
    }

    public static void setCurrentTerminal(Player player, ItemMenuHostLocator locator, ItemStack itemStack, String terminal) {
        if (!(itemStack.getItem() instanceof ItemWUT)) {
            return;
        }
        if (!WUTHandler.hasTerminal(itemStack, terminal)) {
            return;
        }
        assert (itemStack.getTag() != null);
        itemStack.getTag().putString("currentTerminal", terminal);
        WUTHandler.updateClientTerminal((ServerPlayer)player, locator, itemStack.getTag());
    }

    public static boolean hasTerminal(ItemStack terminal, String terminalName) {
        if (terminal.isEmpty()) {
            return false;
        }
        if (terminal.getItem() instanceof ItemWUT) {
            if (!terminalNames.contains(terminalName)) {
                return false;
            }
            if (terminal.getTag() == null) {
                return false;
            }
            return terminal.getTag().getBoolean(terminalName);
        }
        return terminal.getItem().equals((Object)wirelessTerminals.get(terminalName).item());
    }

    public static void cycle(Player player, ItemMenuHostLocator locator, ItemStack itemStack, boolean isHandlingRightClick) {
        if (itemStack.getTag() == null) {
            return;
        }
        String nextTerminal = WUTHandler.getCurrentTerminal(itemStack);
        do {
            int i;
            if (isHandlingRightClick) {
                i = terminalNames.indexOf(nextTerminal) - 1;
                if (i == -1) {
                    i = terminalNames.size() - 1;
                }
            } else {
                i = terminalNames.indexOf(nextTerminal) + 1;
                if (i == terminalNames.size()) {
                    i = 0;
                }
            }
            nextTerminal = terminalNames.get(i);
        } while (!itemStack.getTag().getBoolean(nextTerminal));
        itemStack.getTag().putString("currentTerminal", nextTerminal);
        WUTHandler.updateClientTerminal((ServerPlayer)player, locator, itemStack.getTag());
    }

    public static void updateClientTerminal(ServerPlayer player, ItemMenuHostLocator locator, @Nullable CompoundTag tag) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new UpdateWUTPackage(locator, tag)});
    }

    public static boolean open(Player player, ItemMenuHostLocator locator, boolean returningFromSubmenu) {
        ItemStack is = locator.locateItem(player);
        if (is.getTag() == null) {
            return false;
        }
        String currentTerminal = WUTHandler.getCurrentTerminal(is);
        if (!wirelessTerminals.containsKey(currentTerminal)) {
            player.displayClientMessage(TextConstants.TERMINAL_EMPTY, false);
            return false;
        }
        return wirelessTerminals.get(currentTerminal).containerOpener().tryOpen(player, locator, returningFromSubmenu);
    }

    @Nullable
    public static ItemMenuHostLocator findTerminal(Player player, String terminalName) {
        int i;
        IItemHandler cap = (IItemHandler)player.getCapability(CuriosIntegration.ITEM_HANDLER);
        if (cap != null) {
            for (i = 0; i < cap.getSlots(); ++i) {
                if (!WUTHandler.hasTerminal(cap.getStackInSlot(i), terminalName)) continue;
                return MenuLocators.forCurioSlot((int)i);
            }
        }
        for (i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!WUTHandler.hasTerminal(player.getInventory().getItem(i), terminalName)) continue;
            return MenuLocators.forInventorySlot((int)i);
        }
        return null;
    }

    public static void addTerminal(String name, WTDefinition.ContainerOpener open, WTDefinition.WTMenuHostFactory WTMenuHostFactory2, MenuType<?> menuType, ItemWT item, String hotkeyName, String itemID) {
        if (terminalNames.contains(name)) {
            return;
        }
        ItemStack wut = new ItemStack((ItemLike)AE2wtlibItems.instance().UNIVERSAL_TERMINAL);
        CompoundTag tag = new CompoundTag();
        tag.putBoolean(name, true);
        wut.setTag(tag);
        AE2wtlibItems.instance().UNIVERSAL_TERMINAL.injectAEPower(wut, AE2wtlibItems.instance().UNIVERSAL_TERMINAL.getAEMaxPower(wut), Actionable.MODULATE);
        HotkeyActions.register((HotkeyAction)new Ae2WTLibLocatingService(name), (String)hotkeyName);
        wirelessTerminals.put(name, new WTDefinition(open, WTMenuHostFactory2, menuType, item, wut, TextConstants.formatTerminalName(itemID)));
        terminalNames.add(name);
    }

    public static void addTerminal(String name, WTDefinition.ContainerOpener open, WTDefinition.WTMenuHostFactory WTMenuHostFactory2, MenuType<?> menuType, ItemWT item, String itemID) {
        WUTHandler.addTerminal(name, open, WTMenuHostFactory2, menuType, item, "wireless_" + name + "_terminal", itemID);
    }

    public static void addTerminal(String name, WTDefinition.ContainerOpener open, WTDefinition.WTMenuHostFactory WTMenuHostFactory2, MenuType<?> menuType, ItemWT item) {
        WUTHandler.addTerminal(name, open, WTMenuHostFactory2, menuType, item, "item.ae2wtlib.wireless_" + name + "_terminal");
    }

    public static int getUpgradeCardCount() {
        return terminalNames.size() * 2;
    }
}

