/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut.recipe;

import de.mari_023.ae2wtlib.wut.recipe.CombineSerializer;
import de.mari_023.ae2wtlib.wut.recipe.Common;
import de.mari_023.ae2wtlib.wut.recipe.InputHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class Combine
extends Common {
    public static final CombineSerializer serializer = new CombineSerializer();
    private final Ingredient terminalA;
    private final Ingredient terminalB;
    private final String terminalAName;
    private final String terminalBName;

    public Combine(Ingredient terminalA, Ingredient terminalB, String terminalAName, String TerminalBName) {
        this.terminalA = terminalA;
        this.terminalB = terminalB;
        this.terminalAName = terminalAName;
        this.terminalBName = TerminalBName;
        this.outputStack.getOrCreateTag().putBoolean(terminalAName, true);
        this.outputStack.getOrCreateTag().putBoolean(TerminalBName, true);
    }

    public Ingredient getTerminalA() {
        return this.terminalA;
    }

    public Ingredient getTerminalB() {
        return this.terminalB;
    }

    public String getTerminalAName() {
        return this.terminalAName;
    }

    public String getTerminalBName() {
        return this.terminalBName;
    }

    public boolean matches(CraftingContainer inv, Level world) {
        return !InputHelper.getInputStack(inv, this.terminalA).isEmpty() && !InputHelper.getInputStack(inv, this.terminalB).isEmpty() && InputHelper.getInputCount(inv) == 2;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack wut = Combine.mergeTerminal(this.outputStack.copy(), InputHelper.getInputStack(inv, this.terminalA), this.terminalAName);
        wut = Combine.mergeTerminal(wut, InputHelper.getInputStack(inv, this.terminalB), this.terminalBName);
        return wut;
    }

    public RecipeSerializer<?> getSerializer() {
        return serializer;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList inputs = NonNullList.create();
        inputs.add((Object)this.terminalA);
        inputs.add((Object)this.terminalB);
        return inputs;
    }
}

