/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut.recipe;

import appeng.api.config.Actionable;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.items.tools.powered.WirelessTerminalItem;
import de.mari_023.ae2wtlib.AE2wtlibItems;
import de.mari_023.ae2wtlib.wut.ItemWUT;
import java.util.Iterator;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.level.ItemLike;

public abstract class Common
implements CraftingRecipe {
    private static final String CURRENT_POWER_NBT_KEY = "internalCurrentPower";
    private static final String MAX_POWER_NBT_KEY = "internalMaxPower";
    private static final String TAG_UPGRADES = "upgrades";
    protected final ItemStack outputStack;

    public Common() {
        this.outputStack = new ItemStack((ItemLike)AE2wtlibItems.instance().UNIVERSAL_TERMINAL);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width > 1 || height > 1;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.outputStack;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.EQUIPMENT;
    }

    public static ItemStack mergeTerminal(ItemStack wut, ItemStack toMerge, String terminalName) {
        Item item = wut.getItem();
        if (!(item instanceof ItemWUT)) {
            return ItemStack.EMPTY;
        }
        ItemWUT itemWUT = (ItemWUT)item;
        Item item2 = toMerge.getItem();
        if (!(item2 instanceof WirelessTerminalItem)) {
            return ItemStack.EMPTY;
        }
        WirelessTerminalItem itemWT = (WirelessTerminalItem)item2;
        CompoundTag wutTag = wut.getOrCreateTag();
        wutTag.putBoolean(terminalName, true);
        wut.setTag(wutTag);
        Iterator iterator = itemWT.getUpgrades(toMerge).iterator();
        IUpgradeInventory wutUpgrades = itemWUT.getUpgrades(wut);
        while (iterator.hasNext()) {
            wutUpgrades.addItems((ItemStack)iterator.next());
        }
        itemWUT.onUpgradesChanged(wut, itemWUT.getUpgrades(wut));
        itemWUT.injectAEPower(wut, itemWT.getAECurrentPower(toMerge), Actionable.MODULATE);
        wutTag = wut.getOrCreateTag();
        CompoundTag toMergeTag = toMerge.getOrCreateTag().copy();
        toMergeTag.remove(CURRENT_POWER_NBT_KEY);
        toMergeTag.remove(MAX_POWER_NBT_KEY);
        toMergeTag.remove(TAG_UPGRADES);
        wutTag.merge(toMergeTag);
        wut.setTag(wutTag);
        return wut;
    }
}

