/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut.recipe;

import de.mari_023.ae2wtlib.wut.WUTHandler;
import de.mari_023.ae2wtlib.wut.recipe.Common;
import de.mari_023.ae2wtlib.wut.recipe.InputHelper;
import de.mari_023.ae2wtlib.wut.recipe.UpgradeSerializer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class Upgrade
extends Common {
    public static final UpgradeSerializer serializer = new UpgradeSerializer();
    private final Ingredient terminal;
    private final String terminalName;

    public Upgrade(Ingredient terminal, String terminalName) {
        this.terminal = terminal;
        this.terminalName = terminalName;
        this.outputStack.getOrCreateTag().putBoolean(terminalName, true);
    }

    public Ingredient getTerminal() {
        return this.terminal;
    }

    public String getTerminalName() {
        return this.terminalName;
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ItemStack wut = InputHelper.getInputStack(inv, InputHelper.WUT);
        return !InputHelper.getInputStack(inv, this.terminal).isEmpty() && !wut.isEmpty() && InputHelper.getInputCount(inv) == 2 && !WUTHandler.hasTerminal(wut, this.terminalName);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        return Upgrade.mergeTerminal(InputHelper.getInputStack(inv, InputHelper.WUT).copy(), InputHelper.getInputStack(inv, this.terminal).copy(), this.terminalName);
    }

    public RecipeSerializer<?> getSerializer() {
        return serializer;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList inputs = NonNullList.create();
        inputs.add((Object)this.terminal);
        inputs.add((Object)InputHelper.WUT);
        return inputs;
    }
}

