/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut.select;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import de.mari_023.ae2wtlib.wut.select.AngleHelper;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class WUTSelectScreen
extends Screen {
    private final List<String> terminals = new ArrayList<String>();

    public WUTSelectScreen(ItemStack terminal) {
        super((Component)Component.translatable((String)"gui.ae2wtlib.wireless_universal_terminal"));
        for (String currentTerminal : WUTHandler.terminalNames) {
            if (!WUTHandler.hasTerminal(terminal, currentTerminal)) continue;
            this.terminals.add(currentTerminal);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int angle = 360 / this.terminals.size();
        float hWidth = (float)this.width / 2.0f;
        float hHeight = (float)this.height / 2.0f;
        int selected = (int)AngleHelper.getAngle((float)mouseX - hWidth, (float)mouseY - hHeight) / angle;
        for (int i = 0; i < this.terminals.size(); ++i) {
            WUTSelectScreen.drawSegment(guiGraphics.pose(), i * angle, (i + 1) * angle, hWidth, hHeight, 100, 50, Color.ofRGB((int)125, (int)125, (int)125), i == selected);
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public static void drawSegment(PoseStack poseStack, int startingAngle, int endingAngle, float centerX, float centerY, int outerRadius, int innerRadius, Color color, boolean selected) {
        float y;
        float x;
        int i;
        if (selected) {
            outerRadius += 10;
            color = color.darker(2.0);
        }
        poseStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferBuilder bufferBuilder = Tesselator.getInstance().getBuilder();
        Matrix4f modelMatrix = poseStack.last().pose();
        bufferBuilder.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        for (i = endingAngle; i >= startingAngle; --i) {
            x = AngleHelper.getX(i, outerRadius);
            y = AngleHelper.getY(i, outerRadius);
            bufferBuilder.vertex(modelMatrix, centerX + x, centerY - y, 0.0f).color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).endVertex();
        }
        for (i = startingAngle; i <= endingAngle; ++i) {
            x = AngleHelper.getX(i, innerRadius);
            y = AngleHelper.getY(i, innerRadius);
            bufferBuilder.vertex(modelMatrix, centerX + x, centerY - y, 0.0f).color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).endVertex();
        }
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferBuilder.end());
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

