/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.groups;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.EventResult;
import dev.ftb.mods.ftbessentials.FTBEssentialsEvents;
import dev.ftb.mods.ftbessentials.commands.CommandUtils;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.commands.SimpleConfigurableCommand;
import dev.ftb.mods.ftbessentials.commands.impl.teleporting.HomeCommand;
import dev.ftb.mods.ftbessentials.commands.impl.teleporting.OfflineTeleportCommand;
import dev.ftb.mods.ftbessentials.commands.impl.teleporting.TPACommand;
import dev.ftb.mods.ftbessentials.commands.impl.teleporting.WarpCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.BlockUtil;
import dev.ftb.mods.ftbessentials.util.DimensionFilter;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TeleportingCommands {
    public static final TagKey<Block> IGNORE_RTP_BLOCKS = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("ftbessentials", "ignore_rtp"));
    public static final TagKey<Biome> IGNORE_RTP_BIOMES = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation("ftbessentials", "ignore_rtp"));
    public static final List<FTBCommand> COMMANDS = List.of(new OfflineTeleportCommand(), new HomeCommand(), new WarpCommand(), new TPACommand(), new SimpleConfigurableCommand(FTBEConfig.BACK, (LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"back").executes(context -> TeleportingCommands.back(((CommandSourceStack)context.getSource()).getPlayerOrException())))), new SimpleConfigurableCommand(FTBEConfig.SPAWN, (LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"spawn").executes(context -> TeleportingCommands.spawn(((CommandSourceStack)context.getSource()).getPlayerOrException())))), new SimpleConfigurableCommand(FTBEConfig.RTP, (LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"rtp").executes(context -> TeleportingCommands.rtp(((CommandSourceStack)context.getSource()).getPlayerOrException())))), new SimpleConfigurableCommand(FTBEConfig.TPL, (LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"teleport_last").requires(CommandUtils.isGamemaster())).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(context -> TeleportingCommands.tpLast(((CommandSourceStack)context.getSource()).getPlayerOrException(), (GameProfile)GameProfileArgument.getGameProfiles((CommandContext)context, (String)"player").iterator().next()))))), new SimpleConfigurableCommand(FTBEConfig.TPX, (LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpx").requires(CommandUtils.isGamemaster())).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(context -> TeleportingCommands.tpx(((CommandSourceStack)context.getSource()).getPlayerOrException(), DimensionArgument.getDimension((CommandContext)context, (String)"dimension")))))), new SimpleConfigurableCommand(FTBEConfig.JUMP, (LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"jump").requires(CommandUtils.isGamemaster())).executes(ctx -> TeleportingCommands.jump((CommandSourceStack)ctx.getSource())))));

    public static void register() {
    }

    private static int back(ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            if (data.teleportHistory.isEmpty()) {
                player.displayClientMessage((Component)Component.literal((String)"Teleportation history is empty!").withStyle(ChatFormatting.RED), false);
                return 0;
            }
            if (data.backTeleporter.teleport(player, serverPlayerEntity -> data.teleportHistory.getLast()).runCommand(player) != 0) {
                data.markDirty();
                return 1;
            }
            return 0;
        }).orElse(0);
    }

    private static int spawn(ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            ServerLevel level = player.server.getLevel(Level.OVERWORLD);
            return level == null ? 0 : data.spawnTeleporter.teleport(player, p -> new TeleportPos((Level)level, level.getSharedSpawnPos(), Float.valueOf(level.getSharedSpawnAngle()), Float.valueOf(0.0f))).runCommand(player);
        }).orElse(0);
    }

    private static int rtp(ServerPlayer player) {
        if (!player.hasPermissions(2) && !DimensionFilter.isDimensionOK((ResourceKey<Level>)player.level().dimension())) {
            player.displayClientMessage((Component)Component.literal((String)"You may not use /rtp in this dimension!").withStyle(ChatFormatting.RED), false);
            return 0;
        }
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> data.rtpTeleporter.teleport(player, p -> {
            p.displayClientMessage((Component)Component.literal((String)"Looking for random location..."), false);
            return TeleportingCommands.findBlockPos((ServerLevel)player.level(), p);
        }).runCommand(player)).orElse(0);
    }

    private static TeleportPos findBlockPos(ServerLevel world, ServerPlayer player) {
        for (int attempt = 0; attempt < (Integer)FTBEConfig.RTP_MAX_TRIES.get(); ++attempt) {
            EventResult res;
            double dist = (double)((Integer)FTBEConfig.RTP_MIN_DISTANCE.get()).intValue() + world.random.nextDouble() * (double)((Integer)FTBEConfig.RTP_MAX_DISTANCE.get() - (Integer)FTBEConfig.RTP_MIN_DISTANCE.get());
            double angle = world.random.nextDouble() * Math.PI * 2.0;
            int x = Mth.floor((double)(Math.cos(angle) * dist));
            int y = 256;
            int z = Mth.floor((double)(Math.sin(angle) * dist));
            BlockPos currentPos = new BlockPos(x, y, z);
            if (!world.getWorldBorder().isWithinBounds(currentPos) || world.getBiome(currentPos).is(IGNORE_RTP_BIOMES) || (res = ((FTBEssentialsEvents.RTP)FTBEssentialsEvents.RTP_EVENT.invoker()).teleport(world, player, currentPos, attempt)).isFalse()) continue;
            world.getChunkAt(currentPos);
            BlockPos hmPos = world.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, currentPos);
            if (hmPos.getY() <= 0) continue;
            BlockPos goodPos = null;
            if (hmPos.getY() < world.getLogicalHeight()) {
                goodPos = hmPos;
            } else {
                for (BlockPos newPos : BlockPos.spiralAround((BlockPos)new BlockPos(hmPos.getX(), world.getSeaLevel(), hmPos.getZ()), (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
                    BlockState bs = world.getBlockState(newPos);
                    if (!bs.blocksMotion() || bs.is(IGNORE_RTP_BLOCKS) || !world.isEmptyBlock(newPos.above(1)) || !world.isEmptyBlock(newPos.above(2)) || !world.isEmptyBlock(newPos.above(3))) continue;
                    goodPos = newPos;
                }
            }
            if (goodPos == null) continue;
            player.displayClientMessage((Component)Component.literal((String)String.format("Found good location after %d " + (attempt == 1 ? "attempt" : "attempts") + " @ [x %d, z %d]", attempt, goodPos.getX(), goodPos.getZ())), false);
            return new TeleportPos((ResourceKey<Level>)world.dimension(), goodPos.above());
        }
        player.displayClientMessage((Component)Component.literal((String)"Could not find a valid location to teleport to!").withStyle(ChatFormatting.RED), false);
        return new TeleportPos((Entity)player);
    }

    private static int tpLast(ServerPlayer player, GameProfile to) {
        ServerPlayer toPlayer = player.server.getPlayerList().getPlayer(to.getId());
        if (toPlayer != null) {
            FTBEPlayerData.addTeleportHistory(player);
            new TeleportPos((Entity)toPlayer).teleport(player);
            return 1;
        }
        return FTBEPlayerData.getOrCreate(player.getServer(), to.getId()).map(data -> {
            FTBEPlayerData.addTeleportHistory(player);
            data.getLastSeenPos().teleport(player);
            return 1;
        }).orElse(0);
    }

    private static int tpx(ServerPlayer player, ServerLevel to) {
        player.teleportTo(to, player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
        return 1;
    }

    private static int jump(CommandSourceStack source) {
        try {
            Level level;
            ServerPlayer player = source.getPlayerOrException();
            BlockHitResult res = BlockUtil.getFocusedBlock(player, player.getServer().getPlayerList().getViewDistance() * 16).orElseThrow(() -> new IllegalArgumentException("Not looking at a block"));
            BlockPos.MutableBlockPos mPos = res.getBlockPos().above().mutable();
            while (!(TeleportingCommands.isEmptyShape(level = player.level(), mPos.above()) && TeleportingCommands.isEmptyShape(level, mPos.above(2)) || mPos.getY() >= level.getMaxBuildHeight())) {
                mPos.move(Direction.UP, 2);
            }
            Vec3 vec = Vec3.atBottomCenterOf((Vec3i)mPos);
            player.teleportTo(vec.x(), vec.y(), vec.z());
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("Can't jump: " + e.getMessage())));
        }
        return 0;
    }

    private static boolean isEmptyShape(Level level, BlockPos pos) {
        return level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty();
    }
}

