/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.commands.CommandUtils;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.kit.Kit;
import dev.ftb.mods.ftbessentials.kit.KitManager;
import dev.ftb.mods.ftbessentials.util.BlockUtil;
import dev.ftb.mods.ftbessentials.util.DurationInfo;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.InventoryUtil;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;

public class KitCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        return FTBEConfig.KIT.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        return Collections.singletonList((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kit").requires(CommandUtils.isGamemaster())).then(Commands.literal((String)"create_from_player_inv").then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommand.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "", false))).then(Commands.argument((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"), false)))))).then(Commands.literal((String)"create_from_player_hotbar").then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommand.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "", true))).then(Commands.argument((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.createKitFromPlayer((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"), true)))))).then(Commands.literal((String)"create_from_block_inv").then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> KitCommand.createKitFromBlock((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), ""))).then(Commands.argument((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.createKitFromBlock((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"))))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.deleteKit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"list").executes(ctx -> KitCommand.listKits((CommandSourceStack)ctx.getSource())))).then(Commands.literal((String)"show").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.showKit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"give").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.giveKit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), EntityArgument.getPlayers((CommandContext)ctx, (String)"players"))))))).then(Commands.literal((String)"put_in_block_inv").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.putKitInBlockInv((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"cooldown").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).then(Commands.argument((String)"cooldown", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestCooldowns(builder)).executes(ctx -> KitCommand.modifyCooldown((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"cooldown"))))))).then(Commands.literal((String)"reset_cooldown").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).executes(ctx -> KitCommand.resetCooldowns((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> KitCommand.resetCooldowns((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), EntityArgument.getPlayer((CommandContext)ctx, (String)"player"))))).then(Commands.argument((String)"id", (ArgumentType)UuidArgument.uuid()).executes(ctx -> KitCommand.resetCooldowns((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), UuidArgument.getUuid((CommandContext)ctx, (String)"id"))))))).then(Commands.literal((String)"set_autogrant").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> KitCommand.suggestKits(builder)).then(Commands.argument((String)"grant", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> KitCommand.modifyAutogrant((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), BoolArgumentType.getBool((CommandContext)ctx, (String)"grant")))))));
    }

    private static int putKitInBlockInv(CommandSourceStack source, String kitName) {
        try {
            ServerPlayer player = source.getPlayerOrException();
            BlockHitResult res = BlockUtil.getFocusedBlock(player, 5.5).orElseThrow(() -> new IllegalArgumentException("Not looking at a block"));
            Kit kit = KitManager.getInstance().get(kitName).orElseThrow(() -> new IllegalArgumentException("No such kit: " + kitName));
            if (!InventoryUtil.putItemsInInventory(kit.getItems(), player.level(), res.getBlockPos(), res.getDirection())) {
                throw new RuntimeException("Not enough space");
            }
            source.sendSuccess(() -> Component.literal((String)("Added item(s) from kit '" + kitName + "' to focused inventory")).withStyle(ChatFormatting.YELLOW), false);
            return 1;
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("Can't store kit in inventory: " + e.getMessage())).withStyle(ChatFormatting.RED));
            return 0;
        }
    }

    private static CompletableFuture<Suggestions> suggestKits(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(KitManager.getInstance().allKits().stream().map(Kit::getKitName).toList(), (SuggestionsBuilder)builder);
    }

    private static int createKitFromPlayer(CommandSourceStack source, String name, String cooldown, boolean hotbarOnly) {
        try {
            long secs = DurationInfo.getSeconds(cooldown);
            KitManager.getInstance().createFromPlayerInv(name, source.getPlayerOrException(), secs, hotbarOnly);
            source.sendSuccess(() -> Component.literal((String)("Kit '" + name + "' created")).withStyle(ChatFormatting.YELLOW), false);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("Can't create kit: " + e.getMessage())).withStyle(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    private static int createKitFromBlock(CommandSourceStack source, String name, String cooldown) {
        try {
            long secs = DurationInfo.getSeconds(cooldown);
            ServerPlayer player = source.getPlayerOrException();
            BlockHitResult res = BlockUtil.getFocusedBlock(player, 5.5).orElseThrow(() -> new IllegalArgumentException("Not looking at a block"));
            KitManager.getInstance().createFromBlockInv(name, player.level(), res.getBlockPos(), res.getDirection(), secs);
            source.sendSuccess(() -> Component.literal((String)("Kit '" + name + "' created")).withStyle(ChatFormatting.YELLOW), false);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("Can't create kit: " + e.getMessage())).withStyle(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    private static int giveKit(CommandSourceStack source, String name, Collection<ServerPlayer> players) {
        try {
            players.forEach(player -> KitManager.getInstance().giveKitToPlayer(name, (ServerPlayer)player));
            source.sendSuccess(() -> Component.literal((String)("Kit '" + name + "' given to " + players.size() + " player(s)")).withStyle(ChatFormatting.YELLOW), false);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("Can't give kit to player: " + e.getMessage())).withStyle(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    private static int listKits(CommandSourceStack source) {
        Collection<Kit> kits = KitManager.getInstance().allKits();
        source.sendSuccess(() -> Component.literal((String)(kits.size() + " kit(s)")).withStyle(ChatFormatting.AQUA), false);
        kits.stream().sorted(Comparator.comparing(Kit::getKitName)).forEach(kit -> source.sendSuccess(() -> Component.literal((String)("\u2022 " + kit.getKitName())).withStyle(Style.EMPTY.withColor(ChatFormatting.YELLOW).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/kit show " + kit.getKitName()))), false));
        return 1;
    }

    private static int showKit(CommandSourceStack source, String kitName) {
        KitManager.getInstance().get(kitName).ifPresentOrElse(kit -> {
            source.sendSuccess(() -> Component.literal((String)Strings.repeat((char)'-', (int)40)).withStyle(ChatFormatting.GREEN), false);
            source.sendSuccess(() -> Component.literal((String)"Kit Name: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)kit.getKitName()).withStyle(ChatFormatting.YELLOW)), false);
            if (kit.getCooldown() > 0L) {
                source.sendSuccess(() -> Component.literal((String)"  Cooldown: ").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)TimeUtils.prettyTimeString((long)kit.getCooldown())).withStyle(ChatFormatting.YELLOW)), false);
            } else if (kit.getCooldown() == 0L) {
                source.sendSuccess(() -> Component.literal((String)"  No Cooldown").withStyle(ChatFormatting.AQUA), false);
            } else {
                source.sendSuccess(() -> Component.literal((String)"  One-Time Use").withStyle(ChatFormatting.AQUA), false);
            }
            if (kit.isAutoGrant()) {
                source.sendSuccess(() -> Component.literal((String)"  Autogranted on player login").withStyle(ChatFormatting.AQUA), false);
            }
            source.sendSuccess(() -> Component.literal((String)"  Items:").withStyle(ChatFormatting.AQUA), false);
            for (ItemStack stack : kit.getItems()) {
                source.sendSuccess(() -> Component.literal((String)"  \u2022 ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)(stack.getCount() + " x ")).withStyle(ChatFormatting.WHITE)).append(stack.getDisplayName()), false);
            }
        }, () -> source.sendFailure((Component)Component.literal((String)("No such kit: " + kitName)).withStyle(ChatFormatting.RED)));
        return 1;
    }

    private static int deleteKit(CommandSourceStack source, String kitName) {
        try {
            KitManager.getInstance().deleteKit(kitName);
            source.sendSuccess(() -> Component.literal((String)("Kit '" + kitName + "' deleted")).withStyle(ChatFormatting.YELLOW), false);
        }
        catch (Exception e) {
            source.sendFailure((Component)Component.literal((String)("Can't delete kit '" + kitName + "': " + e.getMessage())).withStyle(ChatFormatting.RED));
            return 0;
        }
        return 1;
    }

    private static int modifyAutogrant(CommandSourceStack source, String kitName, boolean grant) {
        KitManager.getInstance().get(kitName).ifPresentOrElse(kit -> {
            KitManager.getInstance().addKit(kit.withAutoGrant(grant), true);
            source.sendSuccess(() -> Component.literal((String)("Kit '" + kitName + "' autogrant modified: " + grant)).withStyle(ChatFormatting.YELLOW), false);
        }, () -> source.sendFailure((Component)Component.literal((String)("No such kit: " + kitName)).withStyle(ChatFormatting.RED)));
        return 1;
    }

    private static int modifyCooldown(CommandSourceStack source, String kitName, String cooldown) {
        KitManager.getInstance().get(kitName).ifPresentOrElse(kit -> {
            long secs = DurationInfo.getSeconds(cooldown);
            KitManager.getInstance().addKit(kit.withCooldown(secs), true);
            String newTime = secs < 0L ? "One-Time Use" : TimeUtils.prettyTimeString((long)secs);
            source.sendSuccess(() -> Component.literal((String)("Kit '" + kitName + "' cooldown modified: " + newTime)).withStyle(ChatFormatting.YELLOW), false);
        }, () -> source.sendFailure((Component)Component.literal((String)("No such kit: " + kitName)).withStyle(ChatFormatting.RED)));
        return 1;
    }

    private static int resetCooldowns(CommandSourceStack source, String name, ServerPlayer player) {
        return KitCommand.resetCooldowns(source, name, player.getUUID());
    }

    private static int resetCooldowns(CommandSourceStack source, String name, UUID playerId) {
        if (KitManager.getInstance().get(name).isEmpty()) {
            source.sendFailure((Component)Component.literal((String)("Unknown kit: " + name)).withStyle(ChatFormatting.RED));
            return 0;
        }
        if (!FTBEPlayerData.playerExists(playerId)) {
            source.sendFailure((Component)Component.literal((String)("Unknown player ID: " + playerId)).withStyle(ChatFormatting.RED));
            return 0;
        }
        return FTBEPlayerData.getOrCreate(source.getServer(), playerId).map(data -> {
            data.setLastKitUseTime(name, 0L);
            source.sendSuccess(() -> Component.literal((String)("Cooldown for '" + name + "' reset for UUID " + playerId)).withStyle(ChatFormatting.YELLOW), false);
            return 1;
        }).orElse(0);
    }

    private static int resetCooldowns(CommandSourceStack source, String name) {
        if (KitManager.getInstance().get(name).isPresent()) {
            FTBEPlayerData.cleanupKitCooldowns(name);
            source.sendSuccess(() -> Component.literal((String)("Cooldown for '" + name + "' reset for all players")).withStyle(ChatFormatting.YELLOW), false);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)("Unknown kit: " + name)).withStyle(ChatFormatting.RED));
        return 0;
    }
}

