/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.teleporting;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.ftb.mods.ftbessentials.api.records.TPARequest;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class TPACommand
implements FTBCommand {
    private static final HashMap<UUID, TPARequest> REQUESTS = new HashMap();

    @Override
    public boolean enabled() {
        return FTBEConfig.TPA.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<CommandSourceStack>> register() {
        return List.of((LiteralArgumentBuilder)Commands.literal((String)"tpa").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> this.tpa(((CommandSourceStack)context.getSource()).getPlayerOrException(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), false))), (LiteralArgumentBuilder)Commands.literal((String)"tpahere").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> this.tpa(((CommandSourceStack)context.getSource()).getPlayerOrException(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), true))), (LiteralArgumentBuilder)Commands.literal((String)"tpaccept").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> this.tpaccept(((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"id")))), (LiteralArgumentBuilder)Commands.literal((String)"tpdeny").then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.string()).executes(context -> this.tpdeny(((CommandSourceStack)context.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)context, (String)"id")))));
    }

    public int tpa(ServerPlayer player, ServerPlayer target, boolean here) {
        TeleportPos.TeleportResult result;
        FTBEPlayerData dataSource = FTBEPlayerData.getOrCreate((Player)player).orElse(null);
        FTBEPlayerData dataTarget = FTBEPlayerData.getOrCreate((Player)target).orElse(null);
        if (dataSource == null || dataTarget == null) {
            return 0;
        }
        if (REQUESTS.values().stream().anyMatch(r -> r.source() == dataSource && r.target() == dataTarget)) {
            player.displayClientMessage((Component)Component.literal((String)"Request already sent!"), false);
            return 0;
        }
        TeleportPos.TeleportResult teleportResult = result = here ? dataTarget.tpaTeleporter.checkCooldown() : dataSource.tpaTeleporter.checkCooldown();
        if (!result.isSuccess()) {
            return result.runCommand(player);
        }
        TPARequest request = TPACommand.create(dataSource, dataTarget, here);
        MutableComponent component = Component.literal((String)"TPA request! [ ");
        component.append((Component)(here ? target : player).getDisplayName().copy().withStyle(ChatFormatting.YELLOW));
        component.append(" \u27a1 ");
        component.append((Component)(here ? player : target).getDisplayName().copy().withStyle(ChatFormatting.YELLOW));
        component.append(" ]");
        MutableComponent component2 = Component.literal((String)"Click one of these: ");
        component2.append((Component)Component.literal((String)"Accept \u2714").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GREEN).withBold(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpaccept " + request.id())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to Accept")))));
        component2.append(" | ");
        component2.append((Component)Component.literal((String)"Deny \u274c").setStyle(Style.EMPTY.applyFormat(ChatFormatting.RED).withBold(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tpdeny " + request.id())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to Deny")))));
        component2.append(" |");
        target.displayClientMessage((Component)component, false);
        target.displayClientMessage((Component)component2, false);
        player.displayClientMessage((Component)Component.literal((String)"Request sent!"), false);
        return 1;
    }

    public int tpaccept(ServerPlayer player, String id) {
        TeleportPos.TeleportResult result;
        UUID uuid = this.attemptUuid(id);
        if (uuid == null) {
            player.displayClientMessage((Component)Component.literal((String)"Invalid request!"), false);
            return 0;
        }
        TPARequest request = REQUESTS.get(uuid);
        if (request == null) {
            player.displayClientMessage((Component)Component.literal((String)"Invalid request!"), false);
            return 0;
        }
        ServerPlayer sourcePlayer = player.server.getPlayerList().getPlayer(request.source().getUuid());
        if (sourcePlayer == null) {
            player.displayClientMessage((Component)Component.literal((String)"Player has gone offline!"), false);
            return 0;
        }
        TeleportPos.TeleportResult teleportResult = result = request.here() ? request.target().tpaTeleporter.teleport(player, p -> new TeleportPos((Entity)sourcePlayer)) : request.source().tpaTeleporter.teleport(sourcePlayer, p -> new TeleportPos((Entity)player));
        if (result.isSuccess()) {
            REQUESTS.remove(request.id());
        }
        return result.runCommand(player);
    }

    public int tpdeny(ServerPlayer player, String id) {
        UUID uuid = this.attemptUuid(id);
        if (uuid == null) {
            player.displayClientMessage((Component)Component.literal((String)"Invalid request!"), false);
            return 0;
        }
        TPARequest request = REQUESTS.get(uuid);
        if (request == null) {
            player.displayClientMessage((Component)Component.literal((String)"Invalid request!"), false);
            return 0;
        }
        REQUESTS.remove(request.id());
        player.displayClientMessage((Component)Component.literal((String)"Request denied!"), false);
        ServerPlayer player2 = player.server.getPlayerList().getPlayer(request.target().getUuid());
        if (player2 != null) {
            player2.displayClientMessage((Component)Component.literal((String)"Request denied!"), false);
        }
        return 1;
    }

    public static TPARequest create(FTBEPlayerData source, FTBEPlayerData target, boolean here) {
        UUID uuid = UUID.randomUUID();
        TPARequest r = new TPARequest(uuid, source, target, here, System.currentTimeMillis());
        REQUESTS.put(uuid, r);
        return r;
    }

    public static void clearRequests() {
        REQUESTS.clear();
    }

    @Nullable
    private UUID attemptUuid(String id) {
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static HashMap<UUID, TPARequest> requests() {
        return REQUESTS;
    }
}

