/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic;

import com.mojang.serialization.Codec;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.worldgen.ConfigDensityFunction;
import dev.worldgen.tectonic.worldgen.DynamicReferenceDensityFunction;
import dev.worldgen.tectonic.worldgen.ErosionNoiseDensityFunction;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

@Mod(value="tectonic")
public class TectonicNeoforge {
    private static final List<String> enabledPacks = new ArrayList<String>();

    public TectonicNeoforge(IEventBus modEventBus) {
        Tectonic.init((Codec<HolderSet<DensityFunction>>)RegistryCodecs.homogeneousList((ResourceKey)Registries.DENSITY_FUNCTION));
        ConfigHandler.load(FMLPaths.CONFIGDIR.get().resolve("tectonic.json"));
        ConfigHandler.getConfig().enablePacks(ModList.get().isLoaded("terralith"), enabledPacks::add);
        modEventBus.addListener(this::registerDensityFunctionTypes);
        modEventBus.addListener(this::registerEnabledPacks);
    }

    private void registerDensityFunctionTypes(RegisterEvent event) {
        event.register(Registries.DENSITY_FUNCTION_TYPE, helper -> helper.register(Tectonic.idOf("config"), ConfigDensityFunction.CODEC));
        event.register(Registries.DENSITY_FUNCTION_TYPE, helper -> helper.register(Tectonic.idOf("dynamic_reference"), DynamicReferenceDensityFunction.CODEC));
        event.register(Registries.DENSITY_FUNCTION_TYPE, helper -> helper.register(Tectonic.idOf("erosion_noise"), ErosionNoiseDensityFunction.CODEC));
    }

    private void registerEnabledPacks(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            for (String packName : enabledPacks) {
                this.registerDatapack(event, packName);
            }
        }
    }

    private void registerDatapack(AddPackFindersEvent event, String packName) {
        boolean enableBullshitFix = packName.equals("increased_height");
        Path resourcePath = ModList.get().getModFileById("tectonic").getFile().findResource(new String[]{"resourcepacks/" + packName.toLowerCase()});
        Pack dataPack = Pack.readMetaAndCreate((String)("tectonic/" + (enableBullshitFix ? "z" : "") + packName.toLowerCase()), (Component)Component.translatable((String)("pack_name.tectonic." + packName)), (boolean)false, (Pack.ResourcesSupplier)TectonicNeoforge.createSupplier((PackResources)new PathPackResources(resourcePath.getFileName().toString(), resourcePath, false)), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.BUILT_IN);
        event.addRepositorySource(packConsumer -> packConsumer.accept(dataPack));
    }

    protected static Pack.ResourcesSupplier createSupplier(final PackResources packResources) {
        return new Pack.ResourcesSupplier(){

            @NotNull
            public PackResources openPrimary(@NotNull String string) {
                return packResources;
            }

            @NotNull
            public PackResources openFull(@NotNull String string, // Could not load outer class - annotation placement on inner may be incorrect
            @NotNull Pack.Info info) {
                return packResources;
            }
        };
    }
}

