/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.block;

import com.mojang.serialization.MapCodec;
import com.mrbysco.simpleteleporters.block.entity.TeleporterBlockEntity;
import com.mrbysco.simpleteleporters.item.TeleportCrystalItem;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlockEntities;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersItems;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersSoundEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TeleporterBlock
extends BaseEntityBlock {
    public static final MapCodec<TeleporterBlock> CODEC = TeleporterBlock.simpleCodec(TeleporterBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");
    protected static final VoxelShape SHAPE = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.38, (double)1.0);

    public MapCodec<TeleporterBlock> codec() {
        return CODEC;
    }

    public TeleporterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ON, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide() && entity instanceof ServerPlayer) {
            BlockEntity blockEntity;
            ServerPlayer player = (ServerPlayer)entity;
            if (entity.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof TeleporterBlockEntity) {
                TeleporterBlockEntity teleporter = (TeleporterBlockEntity)blockEntity;
                if (!teleporter.hasCrystal()) {
                    player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.error.no_crystal").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
                } else if (!teleporter.isInDimension(entity)) {
                    player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.error.wrong_dimension").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
                } else if (!teleporter.isCoolingDown()) {
                    BlockPos teleportPos = teleporter.getTeleportPos();
                    if (teleportPos == null) {
                        player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.error.unlinked_teleporter").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
                    } else if (level.getBlockState(teleportPos).isSuffocating((BlockGetter)level, teleportPos)) {
                        player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.error.invalid_position").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
                    } else {
                        player.hurtMarked = true;
                        Vec3 playerPos = new Vec3((double)teleportPos.getX() + 0.5, (double)teleportPos.getY(), (double)teleportPos.getZ() + 0.5);
                        player.connection.teleport(playerPos.x(), playerPos.y(), playerPos.z(), entity.getYRot(), entity.getXRot());
                        player.setDeltaMovement(0.0, 0.0, 0.0);
                        player.hasImpulse = true;
                        level.playSound(null, (Entity)player, (SoundEvent)SimpleTeleportersSoundEvents.TELEPORTER_TELEPORT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        teleporter.setCooldown(10);
                        BlockEntity down = level.getBlockEntity(teleportPos.below());
                        if (down instanceof TeleporterBlockEntity) {
                            TeleporterBlockEntity tpDown = (TeleporterBlockEntity)down;
                            tpDown.setCooldown(10);
                        }
                    }
                }
            }
        }
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TeleporterBlockEntity) {
            TeleporterBlockEntity teleporter = (TeleporterBlockEntity)blockEntity;
            if (teleporter.hasCrystal()) {
                ItemStack crystal = teleporter.getCrystal();
                if (!player.addItem(crystal)) {
                    player.drop(crystal, true);
                }
                player.playSound((SoundEvent)SimpleTeleportersSoundEvents.TELEPORTER_CRYSTAL_REMOVED.get(), 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ON, (Comparable)Boolean.valueOf(false)));
                teleporter.setCrystal(ItemStack.EMPTY);
                level.gameEvent((Entity)player, GameEvent.BLOCK_CHANGE, pos);
                return InteractionResult.SUCCESS;
            }
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.isEmpty() && stack.getItem() == SimpleTeleportersItems.ENDER_SHARD.get()) {
                if (TeleportCrystalItem.hasPosition(stack.getTag())) {
                    player.playSound((SoundEvent)SimpleTeleportersSoundEvents.TELEPORTER_CRYSTAL_INSERTED.get(), 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ON, (Comparable)Boolean.valueOf(true)));
                    ItemStack crystal = stack.split(1);
                    teleporter.setCrystal(crystal);
                    return InteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"text.simpleteleporters.error.unlinked_shard").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)), true);
            }
        }
        return InteractionResult.PASS;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        TeleporterBlockEntity teleporter;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TeleporterBlockEntity && (teleporter = (TeleporterBlockEntity)blockEntity).hasCrystal()) {
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)teleporter.getCrystal());
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(state, facing, neighborState, levelAccessor, pos, neighborPos);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter world, BlockPos pos) {
        return SHAPE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ON}).add(new Property[]{WATERLOGGED});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TeleporterBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)ON)).booleanValue()) {
            for (int i = 0; i < 15; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)((float)pos.getX() + 0.2f + random.nextFloat() / 2.0f), (double)((float)pos.getY() + 0.4f), (double)((float)pos.getZ() + 0.2f + random.nextFloat() / 2.0f), 0.0, (double)random.nextFloat(), 0.0);
            }
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        FluidState fluidState = placeContext.getLevel().getFluidState(placeContext.getClickedPos());
        boolean isWater = fluidState.getType().equals(Fluids.WATER);
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TeleporterBlock.createTickerHelper(type, SimpleTeleportersBlockEntities.TELEPORTER.get(), (BlockEntityTicker)(level.isClientSide() ? null : TeleporterBlockEntity::serverTick));
    }
}

