/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.client;

import com.mrbysco.simpleteleporters.item.TeleportCrystalItem;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlocks;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientHandler {
    @SubscribeEvent
    public static void onRender(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            Level level;
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player != null && (level = player.level()) != null) {
                RandomSource random = level.getRandom();
                for (InteractionHand hand : InteractionHand.values()) {
                    BlockPos telePos;
                    CompoundTag nbt;
                    ItemStack stack = player.getItemInHand(hand);
                    if (stack.isEmpty() || !stack.is((Item)SimpleTeleportersItems.ENDER_SHARD.get()) || !TeleportCrystalItem.hasPosition(nbt = stack.getTag())) continue;
                    ResourceKey<Level> dimension = TeleportCrystalItem.getDimensionKey(nbt);
                    if (!level.dimension().equals(dimension) || (telePos = TeleportCrystalItem.getPosition(nbt)) == null) continue;
                    BlockPos downPos = telePos.below();
                    if (level.getBlockState(downPos).is((Block)SimpleTeleportersBlocks.TELEPORTER.get())) {
                        telePos = downPos;
                    }
                    if (player.blockPosition().distManhattan((Vec3i)telePos) >= 15) continue;
                    level.addParticle((ParticleOptions)ParticleTypes.MYCELIUM, random.triangle((double)telePos.getX() + 0.5, 0.2), random.triangle((double)telePos.getY() + 0.5, 0.2), random.triangle((double)telePos.getZ() + 0.5, 0.2), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

