/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.datagen.data;

import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlocks;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class SimpleLootProvider
extends LootTableProvider {
    public SimpleLootProvider(PackOutput packOutput) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(SimpleBlockLootSubProvider::new, LootContextParamSets.BLOCK)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationContext) {
        map.forEach((location, lootTable) -> lootTable.validate(validationContext));
    }

    private static class SimpleBlockLootSubProvider
    extends BlockLootSubProvider {
        protected SimpleBlockLootSubProvider() {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags());
        }

        protected void generate() {
            this.dropSelf((Block)SimpleTeleportersBlocks.TELEPORTER.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return SimpleTeleportersBlocks.BLOCKS.getEntries().stream().map(holder -> (Block)holder.value())::iterator;
        }
    }
}

