/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.simpleteleporters.item;

import com.mrbysco.simpleteleporters.registry.SimpleTeleportersBlocks;
import com.mrbysco.simpleteleporters.registry.SimpleTeleportersSoundEvents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class TeleportCrystalItem
extends Item {
    public TeleportCrystalItem(Item.Properties settings) {
        super(settings);
    }

    public static boolean hasPosition(CompoundTag nbt) {
        return nbt != null && nbt.contains("pos");
    }

    public static int getX(CompoundTag nbt) {
        if (TeleportCrystalItem.hasPosition(nbt)) {
            return TeleportCrystalItem.getPosition(nbt).getX();
        }
        return BlockPos.ZERO.getX();
    }

    public static int getY(CompoundTag nbt) {
        if (TeleportCrystalItem.hasPosition(nbt)) {
            return TeleportCrystalItem.getPosition(nbt).getY();
        }
        return BlockPos.ZERO.getY();
    }

    public static int getZ(CompoundTag nbt) {
        if (TeleportCrystalItem.hasPosition(nbt)) {
            return TeleportCrystalItem.getPosition(nbt).getZ();
        }
        return BlockPos.ZERO.getZ();
    }

    public static BlockPos getPosition(CompoundTag nbt) {
        if (!TeleportCrystalItem.hasPosition(nbt)) {
            return null;
        }
        return BlockPos.of((long)nbt.getLong("pos"));
    }

    public static String getDimensionName(CompoundTag nbt) {
        if (nbt != null && nbt.contains("dimension")) {
            return nbt.getString("dimension");
        }
        return Level.OVERWORLD.location().toString();
    }

    public static ResourceKey<Level> getDimensionKey(CompoundTag nbt) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(TeleportCrystalItem.getDimensionName(nbt)));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (ctx.isSecondaryUseActive()) {
            BlockPos pos;
            Level level;
            Player player = ctx.getPlayer();
            ItemStack stack = ctx.getItemInHand().split(1);
            CompoundTag nbt = stack.getTag();
            if (nbt == null) {
                stack.setTag(new CompoundTag());
                nbt = stack.getTag();
            }
            BlockPos offsetPos = (level = ctx.getLevel()).getBlockState(pos = ctx.getClickedPos()).getCollisionShape((BlockGetter)level, pos).isEmpty() ? pos : (level.getBlockState(pos).is((Block)SimpleTeleportersBlocks.TELEPORTER.get()) ? pos.above() : pos.relative(ctx.getClickedFace()));
            nbt.putLong("pos", offsetPos.asLong());
            String dimensionName = player.level().dimension().location().toString();
            nbt.putString("dimension", dimensionName);
            if (!player.addItem(stack)) {
                player.drop(stack, false);
            }
            MutableComponent msg = Component.translatable((String)"text.simpleteleporters.crystal_info", (Object[])new Object[]{offsetPos.getX(), offsetPos.getY(), offsetPos.getZ(), dimensionName});
            msg.setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN));
            player.displayClientMessage((Component)msg, true);
            player.playSound((SoundEvent)SimpleTeleportersSoundEvents.ENDER_SHARD_LINK.get(), 0.5f, 0.4f / (ctx.getLevel().getRandom().nextFloat() * 0.4f + 0.8f));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        CompoundTag nbt = stack.getTag();
        if (!TeleportCrystalItem.hasPosition(nbt)) {
            MutableComponent unlinked = Component.translatable((String)"text.simpleteleporters.unlinked");
            unlinked.setStyle(Style.EMPTY.withColor(ChatFormatting.RED));
            tooltip.add((Component)unlinked);
            MutableComponent sneakKey = Component.literal((String)"Sneak");
            MutableComponent useKey = Component.literal((String)"Right Click");
            if (level != null && level.isClientSide()) {
                sneakKey = Component.keybind((String)Minecraft.getInstance().options.keyShift.getName());
                useKey = Component.keybind((String)Minecraft.getInstance().options.keyUse.getName());
            }
            MutableComponent info = Component.translatable((String)"text.simpleteleporters.how_to_link", (Object[])new Object[]{sneakKey, useKey});
            info.setStyle(Style.EMPTY.withColor(ChatFormatting.BLUE));
            tooltip.add((Component)info);
        } else {
            MutableComponent pos = Component.translatable((String)"text.simpleteleporters.linked", (Object[])new Object[]{TeleportCrystalItem.getX(nbt), TeleportCrystalItem.getY(nbt), TeleportCrystalItem.getZ(nbt), TeleportCrystalItem.getDimensionName(nbt)});
            pos.setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN));
            tooltip.add((Component)pos);
        }
    }
}

