/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.block.entity;

import com.hidoni.transmog.MathUtils;
import com.hidoni.transmog.inventory.TransmogMenu;
import com.hidoni.transmog.registry.ModBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TransmogrificationTableBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    public static final int FUEL_INDEX = 0;
    private Component name;
    private final ContainerData dataAccess = new ContainerData(){

        public int get(int index) {
            if (index != 0) {
                return 0;
            }
            return TransmogrificationTableBlockEntity.this.fuel;
        }

        public void set(int index, int value) {
            if (index == 0) {
                TransmogrificationTableBlockEntity.this.fuel = value;
                TransmogrificationTableBlockEntity.this.setChanged();
            }
        }

        public int getCount() {
            return 1;
        }
    };
    public int fuel;
    public float oldRotation;
    public float rotation;
    public float targetRotation;
    public int ticks;

    public TransmogrificationTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRANSMOGRIFICATION_TABLE.get(), pos, state);
    }

    public static void rotationTick(Level level, BlockPos pos, BlockState state, TransmogrificationTableBlockEntity entity) {
        entity.oldRotation = entity.rotation;
        entity.rotation = MathUtils.angleWithinBounds(entity.rotation);
        entity.targetRotation = MathUtils.angleWithinBounds(entity.targetRotation + 0.02f);
        float rotationAdd = MathUtils.angleWithinBounds(entity.targetRotation - entity.rotation);
        entity.rotation += rotationAdd * 0.4f;
        ++entity.ticks;
    }

    protected void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putByte("Fuel", (byte)this.fuel);
        if (this.hasCustomName()) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name));
        }
    }

    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.fuel = tag.getByte("Fuel");
        if (tag.contains("CustomName", 8)) {
            this.name = Component.Serializer.fromJson((String)tag.getString("CustomName"));
        }
    }

    @NotNull
    public Component getName() {
        return this.name != null ? this.name : Component.translatable((String)"transmog.transmog_container");
    }

    public void setCustomName(@Nullable Component component) {
        this.name = component;
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    @NotNull
    public Component getDisplayName() {
        return this.getName();
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory inventory, @NotNull Player player) {
        return new TransmogMenu(containerId, inventory, this.level == null ? ContainerLevelAccess.NULL : ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition), this.dataAccess);
    }
}

