/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.gui;

import com.hidoni.transmog.config.Config;
import com.hidoni.transmog.config.TooltipDetailLevel;
import com.hidoni.transmog.config.TransmogRenderOption;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigScreen
extends OptionsSubScreen {
    private final Screen parentScreen;
    private OptionsList list;

    public ConfigScreen(Screen parentScreen) {
        super(parentScreen, Minecraft.getInstance().options, (Component)Component.translatable((String)"transmog.config_title"));
        this.parentScreen = parentScreen;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.list.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 8, ChatFormatting.WHITE.getColor().intValue());
    }

    protected void init() {
        Minecraft minecraft = Objects.requireNonNullElseGet(this.minecraft, Minecraft::getInstance);
        this.list = new OptionsList(minecraft, this.width, this.height - 64, 32, 25);
        this.addConfigOptionsToList();
        this.addWidget((GuiEventListener)this.list);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            Config.writeConfigToFile();
            Objects.requireNonNullElseGet(this.minecraft, Minecraft::getInstance).setScreen(this.parentScreen);
        }).bounds(this.width / 2 - 154, this.height - 28, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            this.removed();
            Objects.requireNonNullElseGet(this.minecraft, Minecraft::getInstance).setScreen(this.parentScreen);
        }).bounds(this.width / 2 + 4, this.height - 28, 150, 20).build());
    }

    private void addConfigOptionsToList() {
        this.list.addBig(new OptionInstance("transmog.config.render", option -> Tooltip.create((Component)Component.translatable((String)option.getTooltipKey())), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(TransmogRenderOption.values()), Codec.INT.xmap(TransmogRenderOption::fromId, TransmogRenderOption::getId)), (Object)Config.renderOption, option -> {
            Config.renderOption = option;
        }));
        this.list.addBig(new OptionInstance("transmog.config.tooltip", option -> Tooltip.create((Component)Component.translatable((String)option.getTooltipKey())), OptionInstance.forOptionEnum(), (OptionInstance.ValueSet)new OptionInstance.Enum(Arrays.asList(TooltipDetailLevel.values()), Codec.INT.xmap(TooltipDetailLevel::fromId, TooltipDetailLevel::getId)), (Object)Config.tooltipDetailLevel, option -> {
            Config.tooltipDetailLevel = option;
        }));
        this.list.addBig(new OptionInstance("transmog.config.disable_during_pvp_duration", OptionInstance.cachedConstantTooltip((Component)Component.translatable((String)"transmog.config.disable_during_pvp_duration.tooltip")), (component, integer) -> Component.translatable((String)"options.generic_value", (Object[])new Object[]{component, integer == 0 ? Component.translatable((String)"transmog.config.render.off") : Component.translatable((String)"transmog.config.disable_during_pvp_duration.label", (Object[])new Object[]{integer})}), (OptionInstance.ValueSet)new OptionInstance.IntRange(0, 120), (Object)Config.pvpDisableDuration, integer -> {
            Config.pvpDisableDuration = integer;
        }));
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderDirtBackground(guiGraphics);
    }

    public void removed() {
        Config.loadConfigFromFile();
    }
}

