/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.platform;

import com.hidoni.transmog.platform.services.IRegistryHelper;
import com.hidoni.transmog.registry.RegistryEntry;
import com.hidoni.transmog.registry.RegistryProvider;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class NeoForgeRegistryHelper
implements IRegistryHelper {
    private static final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();

    @Override
    public <T> RegistryProvider<T> getRegistry(ResourceKey<? extends Registry<T>> resourceKey) {
        final DeferredRegister deferredRegister = DeferredRegister.create(resourceKey, (String)"transmog");
        deferredRegister.register(modEventBus);
        return new RegistryProvider<T>(){

            @Override
            public <I extends T> RegistryEntry<T, I> register(ResourceLocation location, Supplier<? extends I> entrySupplier) {
                final DeferredHolder registered = deferredRegister.register(location.getPath(), entrySupplier);
                return new RegistryEntry<T, I>(){

                    @Override
                    public ResourceLocation getResourceLocation() {
                        return registered.getId();
                    }

                    @Override
                    @Nullable
                    public ResourceKey<T> getResourceKey() {
                        return registered.getKey();
                    }

                    @Override
                    public Holder<T> getHolder() {
                        return registered;
                    }

                    @Override
                    public I get() {
                        return registered.get();
                    }
                };
            }
        };
    }
}

