/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog.renderer;

import com.hidoni.transmog.MathUtils;
import com.hidoni.transmog.block.entity.TransmogrificationTableBlockEntity;
import com.hidoni.transmog.registry.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class TransmogrificationTableBlockEntityRenderer
implements BlockEntityRenderer<TransmogrificationTableBlockEntity> {
    public TransmogrificationTableBlockEntityRenderer(BlockEntityRendererProvider.Context ignoredContext) {
    }

    public void render(@NotNull TransmogrificationTableBlockEntity blockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack stack = new ItemStack((ItemLike)ModItems.VOID_FRAGMENT.get());
        stack.getOrCreateTag().putBoolean("transmog:showFoil", false);
        poseStack.translate(0.5f, 0.9625f, 0.5f);
        float heightExtra = (float)blockEntity.ticks + partialTick;
        poseStack.translate(0.0f, 0.1f + Mth.sin((float)(heightExtra * 0.1f)) * 0.01f, 0.0f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        float deltaRotation = MathUtils.angleWithinBounds(blockEntity.rotation - blockEntity.oldRotation);
        float rotation = blockEntity.oldRotation + deltaRotation * partialTick;
        poseStack.mulPose(Axis.YP.rotation(-rotation));
        itemRenderer.renderStatic(stack, ItemDisplayContext.NONE, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, blockEntity.getLevel(), 0);
        poseStack.popPose();
    }
}

