/*
 * Decompiled with CFR 0.152.
 */
package org.arbor.extrasounds.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.util.RandomSource;

public class SoundSerializer
implements JsonSerializer<Sound> {
    RandomSource r = RandomSource.create();

    public JsonElement serialize(Sound src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        o.addProperty("name", src.getLocation().toString());
        if (src.getVolume().sample(this.r) != 1.0f) {
            o.addProperty("volume", (Number)Float.valueOf(src.getVolume().sample(this.r)));
        }
        if (src.getPitch().sample(this.r) != 1.0f) {
            o.addProperty("pitch", (Number)Float.valueOf(src.getPitch().sample(this.r)));
        }
        if (src.getWeight() != 1) {
            o.addProperty("weight", (Number)src.getWeight());
        }
        if (src.getType() != Sound.Type.FILE) {
            o.addProperty("type", "event");
        }
        if (src.shouldStream()) {
            o.addProperty("stream", Boolean.valueOf(src.shouldStream()));
        }
        if (src.shouldPreload()) {
            o.addProperty("preload", Boolean.valueOf(src.shouldPreload()));
        }
        if (src.getAttenuationDistance() != 16) {
            o.addProperty("attenuation_distance", (Number)src.getAttenuationDistance());
        }
        return o;
    }
}

