/*
 * Decompiled with CFR 0.152.
 */
package org.arbor.extrasounds.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import org.arbor.extrasounds.mapping.SoundDefinition;
import org.jetbrains.annotations.NotNull;

public final class SoundGenerator {
    public final String namespace;
    public final Function<Item, SoundDefinition> itemSoundGenerator;

    private SoundGenerator(String namespace, Function<Item, SoundDefinition> itemSoundGenerator) {
        this.namespace = namespace;
        this.itemSoundGenerator = itemSoundGenerator;
    }

    public static SoundGenerator of(@NotNull String namespace, @NotNull Function<Item, SoundDefinition> itemSoundGenerator) {
        return new SoundGenerator(namespace, itemSoundGenerator);
    }

    public static List<SoundGenerator> auto(@NotNull List<String> namespaces, @NotNull Function<Item, SoundDefinition> itemSoundGenerator) {
        ArrayList<SoundGenerator> list = new ArrayList<SoundGenerator>();
        for (String namespace : namespaces) {
            list.add(SoundGenerator.of(namespace, itemSoundGenerator));
        }
        return list;
    }
}

