/*
 * Decompiled with CFR 0.152.
 */
package org.arbor.extrasounds.mixin.action;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.arbor.extrasounds.misc.SoundManager;
import org.arbor.extrasounds.sounds.SoundType;
import org.arbor.extrasounds.sounds.Sounds;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public abstract class ClientPlayerInteractionManagerMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(method={"performUseItemOn"}, at={@At(value="RETURN", ordinal=2)})
    private void extrasounds$repeaterSwitchSound(LocalPlayer player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        if (this.minecraft.level == null) {
            return;
        }
        BlockPos blockPos = hitResult.getBlockPos();
        BlockState blockState = this.minecraft.level.getBlockState(blockPos);
        if (!blockState.is(Blocks.REPEATER) || !blockState.hasProperty((Property)RepeaterBlock.DELAY)) {
            return;
        }
        if (((InteractionResult)cir.getReturnValue()).consumesAction()) {
            SoundEvent sound = (Integer)blockState.getValue((Property)RepeaterBlock.DELAY) == 1 ? Sounds.Actions.REPEATER_RESET : Sounds.Actions.REPEATER_ADD;
            SoundManager.playSound(sound, SoundType.ACTION, blockPos);
        }
    }
}

