/*
 * Decompiled with CFR 0.152.
 */
package org.arbor.extrasounds.mixin.action;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.arbor.extrasounds.misc.SoundManager;
import org.arbor.extrasounds.sounds.SoundType;
import org.arbor.extrasounds.sounds.Sounds;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"makePoofParticles"}, at={@At(value="HEAD")})
    private void extrasounds$poofSound(CallbackInfo ci) {
        if (!this.level().isClientSide) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        float pitch = (float)Mth.clampedLerp((double)2.0, (double)0.25, (double)(Math.sqrt(this.getBbHeight() * this.getBbWidth()) / 2.5));
        SoundManager.playSound(Sounds.Entities.POOF, SoundType.ACTION, 0.7f, pitch, this.blockPosition());
    }
}

