/*
 * Decompiled with CFR 0.152.
 */
package org.arbor.extrasounds.mixin.inventory;

import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import org.arbor.extrasounds.misc.SoundManager;
import org.arbor.extrasounds.sounds.SoundType;
import org.arbor.extrasounds.sounds.Sounds;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeInventoryScreenMixin
extends EffectRenderingInventoryScreen<CreativeModeInventoryScreen.ItemPickerMenu> {
    @Unique
    private static final CreativeModeTab GROUP_INVENTORY = (CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.INVENTORY);
    @Shadow
    private static CreativeModeTab selectedTab;
    @Shadow
    @Nullable
    private Slot destroyItemSlot;

    @Shadow
    protected abstract boolean checkTabClicked(CreativeModeTab var1, double var2, double var4);

    @Shadow
    protected abstract boolean isCreativeSlot(@Nullable Slot var1);

    public CreativeInventoryScreenMixin(CreativeModeInventoryScreen.ItemPickerMenu screenHandler, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)screenHandler, playerInventory, text);
    }

    @Inject(method={"slotClicked"}, at={@At(value="HEAD")})
    private void extrasounds$creativeInventoryClickEvent(@Nullable Slot slot, int slotId, int button, ClickType actionType, CallbackInfo ci) {
        boolean bOnHotbar;
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        boolean bl = bOnHotbar = slot != null && !this.isCreativeSlot(slot);
        if (actionType == ClickType.THROW && slot != null && slotId >= 0) {
            ItemStack slotStack = slot.getItem().copy();
            if (button == 1 && selectedTab != GROUP_INVENTORY) {
                if (bOnHotbar) {
                    SoundManager.playSound(Sounds.ITEM_DELETE, SoundType.PICKUP);
                    return;
                }
                slotStack.setCount(slotStack.getMaxStackSize());
            } else if (button == 0) {
                slotStack.setCount(1);
            }
            SoundManager.playThrow(slotStack);
            return;
        }
        if (actionType == ClickType.QUICK_MOVE && selectedTab != GROUP_INVENTORY && bOnHotbar && slot.hasItem()) {
            SoundManager.playSound(Sounds.ITEM_DELETE, SoundType.PICKUP);
            return;
        }
        ItemStack cursorStack = ((CreativeModeInventoryScreen.ItemPickerMenu)this.menu).getCarried().copy();
        if (!cursorStack.isEmpty()) {
            if (this.destroyItemSlot != null && slot == this.destroyItemSlot) {
                SoundManager.playSound(Sounds.ITEM_DELETE, SoundType.PICKUP);
                return;
            }
            if (slotId > 0 && actionType != ClickType.QUICK_CRAFT && actionType != ClickType.PICKUP_ALL && !bOnHotbar) {
                SoundManager.playSound(cursorStack, SoundType.PLACE);
                return;
            }
        }
        SoundManager.handleInventorySlot((Player)this.minecraft.player, slot, slotId, cursorStack, actionType, button);
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")})
    private void extrasounds$tabChange(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (button != 0) {
            return;
        }
        double screenX = mouseX - (double)this.leftPos;
        double screenY = mouseY - (double)this.topPos;
        for (CreativeModeTab itemGroup : CreativeModeTabs.tabs()) {
            if (!this.checkTabClicked(itemGroup, screenX, screenY) || selectedTab == itemGroup) continue;
            SoundManager.playSound(itemGroup.getIconItem(), SoundType.PICKUP);
            return;
        }
    }
}

