/*
 * Decompiled with CFR 0.152.
 */
package org.arbor.extrasounds.mixin.inventory;

import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.sounds.SoundSource;
import org.arbor.extrasounds.misc.ESConfig;
import org.arbor.extrasounds.misc.SoundManager;
import org.arbor.extrasounds.sounds.Sounds;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CreativeModeInventoryScreen.ItemPickerMenu.class})
public abstract class CreativeScreenHandlerMixin {
    @Unique
    private int extra_sounds$lastPos = 0;
    @Unique
    private long extra_sounds$lastTime = 0L;

    @Shadow
    protected abstract int getRowIndexForScroll(float var1);

    @Inject(method={"scrollTo"}, at={@At(value="HEAD")})
    private void extrasounds$creativeScreenScroll(float position, CallbackInfo ci) {
        long now = System.currentTimeMillis();
        long timeDiff = now - this.extra_sounds$lastTime;
        int row = this.getRowIndexForScroll(position);
        if (timeDiff > 20L && this.extra_sounds$lastPos != row && (this.extra_sounds$lastPos == 1 || row != 0)) {
            SoundManager.playSound(Sounds.INVENTORY_SCROLL, 0.9f + 0.1f * Math.min(1.0f, 50.0f / (float)timeDiff), SoundSource.PLAYERS, ((Double)ESConfig.CONFIG.INVENTORY.get()).floatValue());
            this.extra_sounds$lastTime = now;
            this.extra_sounds$lastPos = row;
        }
    }
}

