/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.client.gui.IButtonFactory;
import net.p3pp3rf1y.sophisticatedcore.client.gui.INameableEmptySlot;
import net.p3pp3rf1y.sophisticatedcore.client.gui.ISlotDecorationRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SortButtonsPosition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageGuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeGuiManager;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeSettingsTabControl;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.InventoryScrollPanel;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageBackgroundProperties;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageInventorySlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.network.TransferFullSlotPacket;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.ICraftingUIPart;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;
import org.joml.Matrix4f;

public abstract class StorageScreenBase<S extends StorageContainerMenuBase<?>>
extends AbstractContainerScreen<S>
implements InventoryScrollPanel.IInventoryScreen {
    public static final int ERROR_BACKGROUND_COLOR = -267386864;
    public static final int ERROR_BORDER_COLOR = ColorHelper.getColor(DyeColor.RED.getTextureDiffuseColors()) | 0xFF000000;
    private static final int DISABLED_SLOT_COLOR = -1072689136;
    private static final int UPGRADE_TOP_HEIGHT = 7;
    private static final int UPGRADE_SLOT_HEIGHT = 16;
    private static final int UPGRADE_BOTTOM_HEIGHT = 6;
    public static final int UPGRADE_INVENTORY_OFFSET = 21;
    public static final int DISABLED_SLOT_X_POS = -1000;
    static final int SLOTS_Y_OFFSET = 17;
    static final int SLOTS_X_OFFSET = 7;
    public static final int ERROR_SLOT_COLOR = ColorHelper.getColor(DyeColor.RED.getTextureDiffuseColors()) | 0xAA000000;
    private static final int ERROR_TEXT_COLOR = ColorHelper.getColor(DyeColor.RED.getTextureDiffuseColors());
    public static final int HEIGHT_WITHOUT_STORAGE_SLOTS = 114;
    private UpgradeSettingsTabControl settingsTabControl = new UpgradeSettingsTabControl(new Position(0, 0), this, "");
    private final int numberOfUpgradeSlots;
    @Nullable
    private Button sortButton = null;
    @Nullable
    private ToggleButton<SortBy> sortByButton = null;
    private InventoryScrollPanel inventoryScrollPanel = null;
    private final Set<ToggleButton<Boolean>> upgradeSwitches = new HashSet<ToggleButton<Boolean>>();
    private final Map<Integer, UpgradeInventoryPartBase<?>> inventoryParts = new LinkedHashMap();
    private static ICraftingUIPart craftingUIPart = ICraftingUIPart.NOOP;
    private static ISlotDecorationRenderer slotDecorationRenderer = (guiGraphics, slot) -> {};
    protected StorageBackgroundProperties storageBackgroundProperties;
    private static final Set<IButtonFactory> buttonFactories = new HashSet<IButtonFactory>();

    public static void setCraftingUIPart(ICraftingUIPart part) {
        craftingUIPart = part;
    }

    public static void setSlotDecorationRenderer(ISlotDecorationRenderer renderer) {
        slotDecorationRenderer = renderer;
    }

    public static void addButtonFactory(IButtonFactory buttonFactory) {
        buttonFactories.add(buttonFactory);
    }

    protected StorageScreenBase(S menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.numberOfUpgradeSlots = ((StorageContainerMenuBase)this.getMenu()).getNumberOfUpgradeSlots();
        this.updateDimensionsAndSlotPositions(Minecraft.getInstance().getWindow().getGuiScaledHeight());
    }

    public ICraftingUIPart getCraftingUIAddition() {
        return craftingUIPart;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        this.updateDimensionsAndSlotPositions(height);
        super.resize(minecraft, width, height);
    }

    private void updateDimensionsAndSlotPositions(int height) {
        int displayableNumberOfRows = Math.min((height - 114) / 18, ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows());
        int newImageHeight = 114 + this.getStorageInventoryHeight(displayableNumberOfRows);
        this.storageBackgroundProperties = ((StorageContainerMenuBase)this.getMenu()).getNumberOfStorageInventorySlots() + ((StorageContainerMenuBase)this.getMenu()).getColumnsTaken() * ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows() <= 81 ? StorageBackgroundProperties.REGULAR_9_SLOT : StorageBackgroundProperties.REGULAR_12_SLOT;
        this.imageWidth = this.storageBackgroundProperties.getSlotsOnLine() * 18 + 14;
        this.updateStorageSlotsPositions();
        if (displayableNumberOfRows < ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows()) {
            this.storageBackgroundProperties = this.storageBackgroundProperties == StorageBackgroundProperties.REGULAR_9_SLOT ? StorageBackgroundProperties.WIDER_9_SLOT : StorageBackgroundProperties.WIDER_12_SLOT;
            this.imageWidth += 6;
        }
        this.imageHeight = newImageHeight;
        this.inventoryLabelY = this.imageHeight - 94;
        this.inventoryLabelX = 8 + this.storageBackgroundProperties.getPlayerInventoryXOffset();
        this.updatePlayerSlotsPositions();
        this.updateUpgradeSlotsPositions();
    }

    protected int getStorageInventoryHeight(int displayableNumberOfRows) {
        return displayableNumberOfRows * 18;
    }

    @Override
    public Slot getSlot(int slotIndex) {
        return ((StorageContainerMenuBase)this.getMenu()).getSlot(slotIndex);
    }

    protected void updateUpgradeSlotsPositions() {
        int yPosition = 6;
        for (int slotIndex = 0; slotIndex < this.numberOfUpgradeSlots; ++slotIndex) {
            Slot slot = ((StorageContainerMenuBase)this.getMenu()).getSlot(((StorageContainerMenuBase)this.getMenu()).getFirstUpgradeSlot() + slotIndex);
            slot.y = yPosition;
            yPosition += 16;
        }
    }

    protected void updateStorageSlotsPositions() {
        int yPosition = 18;
        int slotIndex = 0;
        while (slotIndex < ((StorageContainerMenuBase)this.getMenu()).getNumberOfStorageInventorySlots()) {
            Slot slot = ((StorageContainerMenuBase)this.getMenu()).getSlot(slotIndex);
            int lineIndex = slotIndex % this.getSlotsOnLine();
            slot.x = 8 + lineIndex * 18;
            slot.y = yPosition;
            if (++slotIndex % this.getSlotsOnLine() != 0) continue;
            yPosition += 18;
        }
    }

    protected void updatePlayerSlotsPositions() {
        int playerInventoryXOffset = this.storageBackgroundProperties.getPlayerInventoryXOffset();
        int yPosition = this.inventoryLabelY + 12;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slotIndex = j + i * 9;
                int xPosition = playerInventoryXOffset + 8 + j * 18;
                Slot slot = ((StorageContainerMenuBase)this.getMenu()).getSlot(((StorageContainerMenuBase)this.getMenu()).getInventorySlotsSize() - 36 + slotIndex);
                slot.x = xPosition;
                slot.y = yPosition;
            }
            yPosition += 18;
        }
        yPosition += 4;
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            int xPosition = playerInventoryXOffset + 8 + slotIndex * 18;
            Slot slot = ((StorageContainerMenuBase)this.getMenu()).getSlot(((StorageContainerMenuBase)this.getMenu()).getInventorySlotsSize() - 36 + 27 + slotIndex);
            slot.x = xPosition;
            slot.y = yPosition;
        }
    }

    protected void init() {
        super.init();
        this.updateInventoryScrollPanel();
        craftingUIPart.setStorageScreen(this);
        this.initUpgradeSettingsControl();
        this.initUpgradeInventoryParts();
        this.addUpgradeSwitches();
        ((StorageContainerMenuBase)this.getMenu()).setUpgradeChangeListener(c -> {
            this.updateStorageSlotsPositions();
            this.updatePlayerSlotsPositions();
            this.updateUpgradeSlotsPositions();
            this.updateInventoryScrollPanel();
            this.children().remove(this.settingsTabControl);
            craftingUIPart.onCraftingSlotsHidden();
            this.initUpgradeSettingsControl();
            this.initUpgradeInventoryParts();
            this.addUpgradeSwitches();
        });
        if (this.shouldShowSortButtons()) {
            this.addSortButtons();
        }
        this.addAdditionalButtons();
    }

    protected boolean shouldShowSortButtons() {
        return true;
    }

    private void addAdditionalButtons() {
        buttonFactories.forEach(factory -> this.addRenderableWidget((GuiEventListener)factory.instantiateButton(this)));
    }

    private void updateInventoryScrollPanel() {
        int numberOfVisibleRows;
        if (this.inventoryScrollPanel != null) {
            this.removeWidget((GuiEventListener)this.inventoryScrollPanel);
        }
        if ((numberOfVisibleRows = this.getNumberOfVisibleRows()) < ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows()) {
            this.inventoryScrollPanel = new InventoryScrollPanel(Minecraft.getInstance(), this, 0, ((StorageContainerMenuBase)this.getMenu()).getNumberOfStorageInventorySlots(), this.getSlotsOnLine(), numberOfVisibleRows * 18, this.getGuiTop() + 17, this.getGuiLeft() + 7);
            this.addRenderableWidget((GuiEventListener)this.inventoryScrollPanel);
            this.inventoryScrollPanel.updateSlotsYPosition();
        } else {
            this.inventoryScrollPanel = null;
        }
    }

    private int getNumberOfVisibleRows() {
        return Math.min((this.imageHeight - 114) / 18, ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows());
    }

    public int getSlotsOnLine() {
        return this.storageBackgroundProperties.getSlotsOnLine() - ((StorageContainerMenuBase)this.getMenu()).getColumnsTaken();
    }

    private void initUpgradeInventoryParts() {
        this.inventoryParts.clear();
        if (((StorageContainerMenuBase)this.getMenu()).getColumnsTaken() == 0) {
            return;
        }
        int numberOfVisibleRows = this.getNumberOfVisibleRows();
        int scrollBarOffset = numberOfVisibleRows < ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows() ? 6 : 0;
        AtomicReference<Position> pos = new AtomicReference<Position>(new Position(7 + this.getSlotsOnLine() * 18 + scrollBarOffset, 17));
        int height = numberOfVisibleRows * 18;
        for (Map.Entry<Integer, UpgradeContainerBase<?, ?>> entry : ((StorageContainerMenuBase)this.getMenu()).getUpgradeContainers().entrySet()) {
            UpgradeContainerBase<?, ?> container = entry.getValue();
            UpgradeGuiManager.getInventoryPart(entry.getKey(), container, pos.get(), height, this).ifPresent(part -> {
                this.inventoryParts.put((Integer)entry.getKey(), (UpgradeInventoryPartBase<?>)part);
                pos.set(new Position(((Position)pos.get()).x() + 36, ((Position)pos.get()).y()));
            });
        }
    }

    private void addUpgradeSwitches() {
        this.upgradeSwitches.clear();
        int switchTop = this.topPos + 8;
        for (int slot = 0; slot < this.numberOfUpgradeSlots; ++slot) {
            if (((StorageContainerMenuBase)this.menu).canDisableUpgrade(slot)) {
                int finalSlot = slot;
                ToggleButton<Boolean> upgradeSwitch = new ToggleButton<Boolean>(new Position(this.leftPos - 22, switchTop), ButtonDefinitions.UPGRADE_SWITCH, button -> ((StorageContainerMenuBase)this.getMenu()).setUpgradeEnabled(finalSlot, !((StorageContainerMenuBase)this.getMenu()).getUpgradeEnabled(finalSlot)), () -> ((StorageContainerMenuBase)this.getMenu()).getUpgradeEnabled(finalSlot));
                this.addWidget(upgradeSwitch);
                this.upgradeSwitches.add(upgradeSwitch);
            }
            switchTop += 16;
        }
    }

    private void addSortButtons() {
        SortButtonsPosition sortButtonsPosition = (SortButtonsPosition)((Object)Config.CLIENT.sortButtonsPosition.get());
        if (sortButtonsPosition == SortButtonsPosition.HIDDEN) {
            return;
        }
        Position pos = this.getSortButtonsPosition(sortButtonsPosition);
        this.sortButton = new Button(new Position(pos.x(), pos.y()), ButtonDefinitions.SORT, button -> {
            if (button == 0) {
                ((StorageContainerMenuBase)this.getMenu()).sort();
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Sorted"), true);
            }
        });
        this.addWidget(this.sortButton);
        this.sortByButton = new ToggleButton<SortBy>(new Position(pos.x() + 14, pos.y()), ButtonDefinitions.SORT_BY, button -> {
            if (button == 0) {
                ((StorageContainerMenuBase)this.getMenu()).setSortBy(((StorageContainerMenuBase)this.getMenu()).getSortBy().next());
            }
        }, () -> ((StorageContainerMenuBase)this.getMenu()).getSortBy());
        this.addWidget(this.sortByButton);
    }

    private Position getSortButtonsPosition(SortButtonsPosition sortButtonsPosition) {
        return switch (sortButtonsPosition) {
            case SortButtonsPosition.BELOW_UPGRADES -> new Position(this.leftPos - 21 - 2, this.topPos + this.getUpgradeHeightWithoutBottom() + 6 + 2);
            case SortButtonsPosition.BELOW_UPGRADE_TABS -> new Position(this.settingsTabControl.getX() + 2, this.settingsTabControl.getY() + Math.max(0, this.settingsTabControl.getHeight() + 2));
            default -> new Position(this.leftPos + this.imageWidth - 34, this.topPos + 4);
        };
    }

    private void initUpgradeSettingsControl() {
        this.settingsTabControl = new UpgradeSettingsTabControl(new Position(this.leftPos + this.imageWidth, this.topPos + 4), this, this.getStorageSettingsTabTooltip());
        this.addWidget(this.settingsTabControl);
    }

    protected abstract String getStorageSettingsTabTooltip();

    public int getUpgradeHeight() {
        return this.getUpgradeHeightWithoutBottom() + 7;
    }

    protected int getUpgradeHeightWithoutBottom() {
        return 6 + this.numberOfUpgradeSlots * 16;
    }

    public Optional<Rect2i> getSortButtonsRectangle() {
        if (this.sortButton == null || this.sortByButton == null) {
            return Optional.empty();
        }
        return GuiHelper.getPositiveRectangle(this.sortButton.getX(), this.sortButton.getY(), this.sortByButton.getX() + this.sortByButton.getWidth() - this.sortButton.getX(), this.sortByButton.getY() + this.sortByButton.getHeight() - this.sortButton.getY());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (((StorageContainerMenuBase)this.menu).detectSettingsChangeAndReload()) {
            this.updateStorageSlotsPositions();
            this.updatePlayerSlotsPositions();
            this.updateInventoryScrollPanel();
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, -20.0f);
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        poseStack.popPose();
        this.settingsTabControl.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderSuper(guiGraphics, mouseX, mouseY, partialTicks);
        this.settingsTabControl.renderTooltip((Screen)this, guiGraphics, mouseX, mouseY);
        if (this.sortButton != null && this.sortByButton != null) {
            this.sortButton.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.sortByButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.upgradeSwitches.forEach(us -> us.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.renderErrorOverlay(guiGraphics);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderSuper(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ItemStack itemstack;
        int i = this.leftPos;
        int j = this.topPos;
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Background((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        RenderSystem.disableDepthTest();
        this.hoveredSlot = null;
        for (Renderable widget : this.renderables) {
            widget.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)i, (double)j, 0.0);
        for (int k = 0; k < 36; ++k) {
            Slot slot = ((StorageContainerMenuBase)this.getMenu()).getSlot(((StorageContainerMenuBase)this.getMenu()).getInventorySlotsSize() - 36 + k);
            if (slot.isActive()) {
                this.renderSlot(guiGraphics, slot);
            }
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.isActive()) continue;
            this.hoveredSlot = slot;
            int l = slot.x;
            int i1 = slot.y;
            StorageScreenBase.renderSlotHighlight((GuiGraphics)guiGraphics, (int)l, (int)i1, (int)0, (int)this.getSlotColor(k));
        }
        this.renderLabels(guiGraphics, mouseX, mouseY);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        ItemStack itemStack = itemstack = this.draggingItem.isEmpty() ? ((StorageContainerMenuBase)this.menu).getCarried() : this.draggingItem;
        if (!itemstack.isEmpty()) {
            int i2 = this.draggingItem.isEmpty() ? 8 : 16;
            String s = null;
            if (!this.draggingItem.isEmpty() && this.isSplittingStack) {
                itemstack = itemstack.copy();
                itemstack.setCount(Mth.ceil((float)((float)itemstack.getCount() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1) {
                itemstack = itemstack.copy();
                itemstack.setCount(this.quickCraftingRemainder);
                if (itemstack.isEmpty()) {
                    s = ChatFormatting.YELLOW + "0";
                }
            }
            this.renderFloatingItem(guiGraphics, itemstack, mouseX - i - 8, mouseY - j - i2, s);
        }
        poseStack.popPose();
        RenderSystem.enableDepthTest();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        this.renderUpgradeInventoryParts(guiGraphics, mouseX, mouseY);
        this.renderUpgradeSlots(guiGraphics, mouseX, mouseY);
        if (this.inventoryScrollPanel == null) {
            this.renderStorageInventorySlots(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderUpgradeInventoryParts(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.inventoryParts.values().forEach(ip -> ip.render(guiGraphics, mouseX, mouseY));
    }

    private void renderStorageInventorySlots(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderStorageInventorySlots(guiGraphics, mouseX, mouseY, true);
    }

    private void renderStorageInventorySlots(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean canShowHover) {
        for (int slotId = 0; slotId < ((StorageContainerMenuBase)this.menu).realInventorySlots.size(); ++slotId) {
            Slot slot = ((StorageContainerMenuBase)this.menu).realInventorySlots.get(slotId);
            this.renderSlot(guiGraphics, slot);
            if (!canShowHover || !this.isHovering(slot, mouseX, mouseY) || !slot.isActive()) continue;
            this.hoveredSlot = slot;
            StorageScreenBase.renderSlotHighlight((GuiGraphics)guiGraphics, (int)slot.x, (int)slot.y, (int)0, (int)this.getSlotColor(slotId));
        }
    }

    private void renderUpgradeSlots(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (int slotId = 0; slotId < ((StorageContainerMenuBase)this.menu).upgradeSlots.size(); ++slotId) {
            Slot slot = ((StorageContainerMenuBase)this.menu).upgradeSlots.get(slotId);
            if (slot.x != -1000) {
                this.renderSlot(guiGraphics, slot);
                if (!slot.isActive()) {
                    this.renderSlotOverlay(guiGraphics, slot, -1072689136);
                }
            }
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.isActive()) continue;
            this.hoveredSlot = slot;
            StorageScreenBase.renderSlotHighlight((GuiGraphics)guiGraphics, (int)slot.x, (int)slot.y, (int)0, (int)this.getSlotColor(slotId));
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        int i = slot.x;
        int j = slot.y;
        ItemStack stackToRender = slot.getItem();
        boolean flag = false;
        boolean rightClickDragging = slot == this.clickedSlot && !this.draggingItem.isEmpty() && !this.isSplittingStack;
        ItemStack carriedStack = ((StorageContainerMenuBase)this.getMenu()).getCarried();
        String stackCountText = null;
        if (slot == this.clickedSlot && !this.draggingItem.isEmpty() && this.isSplittingStack && !stackToRender.isEmpty()) {
            stackToRender = stackToRender.copy();
            stackToRender.setCount(stackToRender.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !carriedStack.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (StorageContainerMenuBase.canItemQuickReplace(slot, carriedStack) && ((StorageContainerMenuBase)this.menu).canDragTo(slot)) {
                int slotLimit;
                flag = true;
                int slotStackCount = stackToRender.isEmpty() ? 0 : stackToRender.getCount();
                int renderCount = AbstractContainerMenu.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)this.quickCraftingType, (ItemStack)carriedStack) + slotStackCount;
                if (renderCount > (slotLimit = slot.getMaxStackSize(stackToRender))) {
                    stackCountText = ChatFormatting.YELLOW + CountAbbreviator.abbreviate(slotLimit);
                }
                stackToRender = carriedStack.copyWithCount(renderCount);
            } else {
                this.quickCraftSlots.remove(slot);
                this.recalculateQuickCraftRemaining();
            }
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        if (stackToRender.isEmpty() && slot.isActive()) {
            this.renderSlotBackground(guiGraphics, slot, i, j);
        } else if (!rightClickDragging) {
            this.renderStack(guiGraphics, i, j, stackToRender, flag, stackCountText);
            slotDecorationRenderer.renderDecoration(guiGraphics, slot);
        }
        poseStack.popPose();
    }

    private void renderStack(GuiGraphics guiGraphics, int x, int y, ItemStack itemstack, boolean flag, @Nullable String stackCountText) {
        if (flag) {
            guiGraphics.fill(x, y, x + 16, y + 16, -2130706433);
        }
        RenderSystem.enableDepthTest();
        guiGraphics.renderItem(itemstack, x, y);
        if (this.shouldUseSpecialCountRender(itemstack)) {
            guiGraphics.renderItemDecorations(this.font, itemstack, x, y, "");
            if (stackCountText == null) {
                stackCountText = CountAbbreviator.abbreviate(itemstack.getCount());
            }
            this.renderStackCount(guiGraphics, stackCountText, x, y);
        } else {
            guiGraphics.renderItemDecorations(this.font, itemstack, x, y, stackCountText);
        }
    }

    private void renderSlotBackground(GuiGraphics guiGraphics, Slot slot, int i, int j) {
        Optional<ItemStack> memorizedStack = ((StorageContainerMenuBase)this.getMenu()).getMemorizedStackInSlot(slot.index);
        if (memorizedStack.isPresent()) {
            guiGraphics.renderItem(memorizedStack.get(), i, j);
            this.drawStackOverlay(guiGraphics, i, j);
        } else if (!((StorageContainerMenuBase)this.getMenu()).getSlotFilterItem(slot.index).isEmpty()) {
            guiGraphics.renderItem(((StorageContainerMenuBase)this.getMenu()).getSlotFilterItem(slot.index), i, j);
            this.drawStackOverlay(guiGraphics, i, j);
        } else {
            Pair pair = slot.getNoItemIcon();
            if (pair != null) {
                TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.minecraft.getTextureAtlas((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
                guiGraphics.blit(i, j, 0, 16, 16, textureatlassprite);
            }
        }
    }

    private void drawStackOverlay(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.pose().pushPose();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        guiGraphics.blit(GuiHelper.GUI_CONTROLS, x, y, 77, 0, 16, 16);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        guiGraphics.pose().popPose();
    }

    private boolean shouldUseSpecialCountRender(ItemStack itemstack) {
        return itemstack.getCount() > 99;
    }

    private void renderSlotOverlay(GuiGraphics guiGraphics, Slot slot, int slotColor) {
        this.renderSlotOverlay(guiGraphics, slot, slotColor, 0, 16);
    }

    private void renderSlotOverlay(GuiGraphics guiGraphics, Slot slot, int slotColor, int yOffset, int height) {
        this.renderOverlay(guiGraphics, slotColor, slot.x, slot.y + yOffset, 16, height);
    }

    public void renderOverlay(GuiGraphics guiGraphics, int slotColor, int xPos, int yPos, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        guiGraphics.fillGradient(xPos, yPos, xPos + width, yPos + height, 0, slotColor, slotColor);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.drawInventoryBg(guiGraphics, x, y, this.storageBackgroundProperties.getTextureName());
        if (this.inventoryScrollPanel == null) {
            this.drawSlotBg(guiGraphics, x, y);
            this.drawSlotOverlays(guiGraphics);
        }
        this.drawUpgradeBackground(guiGraphics);
    }

    protected void drawSlotBg(GuiGraphics guiGraphics, int x, int y) {
        int inventorySlots = ((StorageContainerMenuBase)this.getMenu()).getNumberOfStorageInventorySlots();
        int slotsOnLine = this.getSlotsOnLine();
        int slotRows = inventorySlots / slotsOnLine;
        int remainingSlots = inventorySlots % slotsOnLine;
        GuiHelper.renderSlotsBackground(guiGraphics, x + 7, y + 17, slotsOnLine, slotRows, remainingSlots);
    }

    private void drawSlotOverlays(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)this.getGuiLeft(), (float)this.getGuiTop(), 0.0f);
        for (int slotNumber = 0; slotNumber < ((StorageContainerMenuBase)this.menu).getNumberOfStorageInventorySlots(); ++slotNumber) {
            List<Integer> colors = ((StorageContainerMenuBase)this.menu).getSlotOverlayColors(slotNumber);
            if (colors.isEmpty()) continue;
            int stripeHeight = 16 / colors.size();
            int i = 0;
            for (int slotColor : colors) {
                int yOffset = i * stripeHeight;
                this.renderSlotOverlay(guiGraphics, ((StorageContainerMenuBase)this.menu).getSlot(slotNumber), slotColor | 0x50000000, yOffset, i == colors.size() - 1 ? 16 - yOffset : stripeHeight);
                ++i;
            }
        }
        poseStack.popPose();
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        this.inventoryParts.values().forEach(part -> part.renderTooltip(this, guiGraphics, x, y));
        if (((StorageContainerMenuBase)this.getMenu()).getCarried().isEmpty() && this.hoveredSlot != null) {
            if (this.hoveredSlot.hasItem()) {
                super.renderTooltip(guiGraphics, x, y);
            } else {
                INameableEmptySlot emptySlot;
                Slot slot = this.hoveredSlot;
                if (slot instanceof INameableEmptySlot && (emptySlot = (INameableEmptySlot)slot).hasEmptyTooltip()) {
                    guiGraphics.renderComponentTooltip(this.font, Collections.singletonList(emptySlot.getEmptyTooltip()), x, y);
                }
            }
        }
        if (this.sortButton != null) {
            this.sortButton.renderTooltip((Screen)this, guiGraphics, x, y);
        }
        if (this.sortByButton != null) {
            this.sortByButton.renderTooltip((Screen)this, guiGraphics, x, y);
        }
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack itemStack) {
        List ret = StorageScreenBase.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)itemStack);
        if (this.hoveredSlot != null && this.hoveredSlot.getMaxStackSize() > 64) {
            ret.add(Component.translatable((String)"gui.sophisticatedcore.tooltip.stack_count", (Object[])new Object[]{Component.literal((String)NumberFormat.getNumberInstance().format(itemStack.getCount())).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)" / ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)NumberFormat.getNumberInstance().format(this.hoveredSlot.getMaxStackSize(itemStack))).withStyle(ChatFormatting.DARK_AQUA))}).withStyle(ChatFormatting.GRAY));
        }
        return ret;
    }

    public void drawInventoryBg(GuiGraphics guiGraphics, int x, int y, ResourceLocation textureName) {
        StorageGuiHelper.renderStorageBackground(new Position(x, y), guiGraphics, textureName, this.imageWidth, this.imageHeight - 114);
    }

    private void drawUpgradeBackground(GuiGraphics guiGraphics) {
        if (this.numberOfUpgradeSlots == 0) {
            return;
        }
        int heightWithoutBottom = this.getUpgradeHeightWithoutBottom();
        guiGraphics.blit(GuiHelper.GUI_CONTROLS, this.leftPos - 21, this.topPos, 0.0f, 0.0f, 26, 4, 256, 256);
        guiGraphics.blit(GuiHelper.GUI_CONTROLS, this.leftPos - 21, this.topPos + 4, 0.0f, 4.0f, 25, heightWithoutBottom - 4, 256, 256);
        guiGraphics.blit(GuiHelper.GUI_CONTROLS, this.leftPos - 21, this.topPos + heightWithoutBottom, 0.0f, 198.0f, 25, 6, 256, 256);
        boolean previousHasSwitch = false;
        for (int slot = 0; slot < this.numberOfUpgradeSlots; ++slot) {
            if (((StorageContainerMenuBase)this.menu).canDisableUpgrade(slot)) {
                int y = this.topPos + 5 + slot * 16 + (previousHasSwitch ? 1 : 0);
                guiGraphics.blit(GuiHelper.GUI_CONTROLS, this.leftPos - 21 - 4, y, 0.0f, (float)(204 + (previousHasSwitch ? 1 : 0)), 7, 18 - (previousHasSwitch ? 1 : 0), 256, 256);
                previousHasSwitch = true;
                continue;
            }
            previousHasSwitch = false;
        }
    }

    public UpgradeSettingsTabControl getUpgradeSettingsControl() {
        return this.settingsTabControl;
    }

    @Nullable
    public Slot findSlot(double mouseX, double mouseY) {
        Slot slot;
        int i;
        for (i = 0; i < ((StorageContainerMenuBase)this.menu).upgradeSlots.size(); ++i) {
            slot = ((StorageContainerMenuBase)this.menu).upgradeSlots.get(i);
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.isActive()) continue;
            return slot;
        }
        if (this.inventoryScrollPanel != null) {
            Optional<Slot> result = this.inventoryScrollPanel.findSlot(mouseX, mouseY);
            if (result.isPresent()) {
                return result.get();
            }
            slot = super.findSlot(mouseX, mouseY);
            return slot == null || ((StorageContainerMenuBase)this.menu).isStorageInventorySlot(slot.index) ? null : slot;
        }
        for (i = 0; i < ((StorageContainerMenuBase)this.menu).realInventorySlots.size(); ++i) {
            slot = ((StorageContainerMenuBase)this.menu).realInventorySlots.get(i);
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.isActive()) continue;
            return slot;
        }
        return super.findSlot(mouseX, mouseY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (UpgradeInventoryPartBase<?> inventoryPart : this.inventoryParts.values()) {
            if (!inventoryPart.handleMouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        this.handleQuickMoveAll(mouseX, mouseY, button);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private void handleQuickMoveAll(double mouseX, double mouseY, int button) {
        Slot slot = this.findSlot(mouseX, mouseY);
        if (this.doubleclick && !((StorageContainerMenuBase)this.getMenu()).getCarried().isEmpty() && slot != null && button == 0 && ((StorageContainerMenuBase)this.menu).canTakeItemForPickAll(ItemStack.EMPTY, slot) && StorageScreenBase.hasShiftDown() && !this.lastQuickMoved.isEmpty()) {
            for (Slot slot2 : ((StorageContainerMenuBase)this.menu).realInventorySlots) {
                this.tryQuickMoveSlot(button, slot, slot2);
            }
        }
    }

    private void tryQuickMoveSlot(int button, Slot slot, Slot slot2) {
        ItemStack slotItem;
        if (slot2.mayPickup((Player)this.minecraft.player) && slot2.hasItem() && slot2.isSameInventory(slot) && ItemStack.isSameItemSameTags((ItemStack)this.lastQuickMoved, (ItemStack)(slotItem = slot2.getItem()))) {
            if (slotItem.getCount() > slotItem.getMaxStackSize()) {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new TransferFullSlotPacket(slot2.index)});
            } else {
                this.slotClicked(slot2, slot2.index, button, ClickType.QUICK_MOVE);
            }
        }
    }

    protected void slotClicked(Slot slot, int slotNumber, int mouseButton, ClickType type) {
        if (type == ClickType.PICKUP_ALL && !((StorageContainerMenuBase)this.menu).getSlotUpgradeContainer(slot).map(c -> c.allowsPickupAll(slot)).orElse(true).booleanValue()) {
            type = ClickType.PICKUP;
        }
        this.handleInventoryMouseClick(slotNumber, mouseButton, type);
    }

    private void handleInventoryMouseClick(int slotNumber, int mouseButton, ClickType type) {
        ItemStack itemstack;
        int lastChecked;
        ItemStack slotStack;
        ItemStack itemstack2;
        int i;
        StorageContainerMenuBase menu = (StorageContainerMenuBase)this.getMenu();
        ArrayList realInventoryItems = new ArrayList(menu.realInventorySlots.size());
        menu.realInventorySlots.forEach(slot -> realInventoryItems.add(slot.getItem().copy()));
        ArrayList upgradeItems = new ArrayList(menu.upgradeSlots.size());
        menu.upgradeSlots.forEach(slot -> upgradeItems.add(slot.getItem().copy()));
        menu.clicked(slotNumber, mouseButton, type, (Player)this.minecraft.player);
        Int2ObjectOpenHashMap changedSlotIndexes = new Int2ObjectOpenHashMap();
        int inventorySlotsToCheck = Math.min(realInventoryItems.size() - 36, menu.getInventorySlotsSize() - 36);
        for (i = 0; i < inventorySlotsToCheck; ++i) {
            ItemStack slotStack2;
            itemstack2 = (ItemStack)realInventoryItems.get(i);
            if (ItemStack.matches((ItemStack)itemstack2, (ItemStack)(slotStack2 = menu.getSlot(i).getItem()))) continue;
            changedSlotIndexes.put(i, (Object)slotStack2.copy());
        }
        for (i = 0; i < 36; ++i) {
            int slotIndex;
            itemstack2 = (ItemStack)realInventoryItems.get(realInventoryItems.size() - 36 + i);
            if (ItemStack.matches((ItemStack)itemstack2, (ItemStack)(slotStack = menu.getSlot(slotIndex = menu.getInventorySlotsSize() - 36 + i).getItem()))) continue;
            changedSlotIndexes.put(slotIndex, (Object)slotStack.copy());
        }
        int upgradeSlotsToCheck = Math.min(menu.getUpgradeSlotsSize(), upgradeItems.size());
        for (lastChecked = 0; lastChecked < upgradeSlotsToCheck && ItemStack.matches((ItemStack)(itemstack = (ItemStack)upgradeItems.get(lastChecked)), (ItemStack)(slotStack = menu.getSlot(menu.getInventorySlotsSize() + lastChecked).getItem())); ++lastChecked) {
        }
        for (int i2 = upgradeSlotsToCheck - 1; i2 >= lastChecked; --i2) {
            int slotIndex;
            ItemStack slotStack3;
            ItemStack itemstack3 = (ItemStack)upgradeItems.get(i2);
            if (ItemStack.matches((ItemStack)itemstack3, (ItemStack)(slotStack3 = menu.getSlot(slotIndex = menu.getInventorySlotsSize() + i2).getItem()))) continue;
            changedSlotIndexes.put(slotIndex, (Object)slotStack3.copy());
        }
        this.minecraft.player.connection.send((Packet)new ServerboundContainerClickPacket(menu.containerId, menu.getStateId(), slotNumber, mouseButton, type, menu.getCarried().copy(), (Int2ObjectMap)changedSlotIndexes));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Slot slot = this.findSlot(mouseX, mouseY);
        if (StorageScreenBase.hasShiftDown() && StorageScreenBase.hasControlDown() && slot instanceof StorageInventorySlot && button == 0) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new TransferFullSlotPacket(slot.index)});
            return true;
        }
        GuiEventListener focused = this.getFocused();
        if (focused != null && !focused.isMouseOver(mouseX, mouseY) && focused instanceof WidgetBase) {
            WidgetBase widgetBase = (WidgetBase)focused;
            widgetBase.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver(mouseX, mouseY) || !child.mouseDragged(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        Slot slot = this.findSlot(mouseX, mouseY);
        ItemStack itemstack = ((StorageContainerMenuBase)this.getMenu()).getCarried();
        if (this.isQuickCrafting) {
            if (slot != null && !itemstack.isEmpty() && (itemstack.getCount() > this.quickCraftSlots.size() || this.quickCraftingType == 2) && StorageContainerMenuBase.canItemQuickReplace(slot, itemstack) && slot.mayPlace(itemstack) && ((StorageContainerMenuBase)this.menu).canDragTo(slot) && this.isAllowedSlotCombination(slot, itemstack)) {
                this.quickCraftSlots.add(slot);
                this.recalculateQuickCraftRemaining();
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    private boolean isAllowedSlotCombination(Slot slot, ItemStack carried) {
        UpgradeItemBase upgradeItem;
        Item item;
        if (this.quickCraftSlots.isEmpty() || !((item = carried.getItem()) instanceof UpgradeItemBase) || (upgradeItem = (UpgradeItemBase)item).getInventoryColumnsTaken() == 0) {
            return true;
        }
        return this.quickCraftSlots.contains(slot) || !(this.quickCraftSlots.iterator().next() instanceof StorageContainerMenuBase.StorageUpgradeSlot) && !(slot instanceof StorageContainerMenuBase.StorageUpgradeSlot);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.hasClickedOutside(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && this.hasClickedOutsideOfUpgradeSlots(mouseX, mouseY) && this.hasClickedOutsideOfUpgradeSettings(mouseX, mouseY);
    }

    private boolean hasClickedOutsideOfUpgradeSettings(double mouseX, double mouseY) {
        return this.settingsTabControl.getTabRectangles().stream().noneMatch(r -> r.contains((int)mouseX, (int)mouseY));
    }

    private boolean hasClickedOutsideOfUpgradeSlots(double mouseX, double mouseY) {
        return this.getUpgradeSlotsRectangle().map(r -> r.contains((int)mouseX, (int)mouseY)).orElse(false) == false;
    }

    public Optional<Rect2i> getUpgradeSlotsRectangle() {
        return this.numberOfUpgradeSlots == 0 ? Optional.empty() : GuiHelper.getPositiveRectangle(this.leftPos - 21 + 4, this.topPos, 25, this.getUpgradeHeight());
    }

    private void renderStackCount(GuiGraphics guiGraphics, String count, int x, int y) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 200.0);
        float scale = Math.min(1.0f, 16.0f / (float)this.font.width(count));
        if (scale < 1.0f) {
            poseStack.scale(scale, scale, 1.0f);
        }
        MultiBufferSource.BufferSource renderBuffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        this.font.drawInBatch(count, ((float)(x + 19 - 2) - (float)this.font.width(count) * scale) / scale, ((float)(y + 6 + 3) + (1.0f / (scale * scale) - 1.0f)) / scale, 0xFFFFFF, true, poseStack.last().pose(), (MultiBufferSource)renderBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        renderBuffer.endBatch();
        poseStack.popPose();
    }

    protected void recalculateQuickCraftRemaining() {
        ItemStack carriedStack = ((StorageContainerMenuBase)this.getMenu()).getCarried();
        if (!carriedStack.isEmpty() && this.isQuickCrafting) {
            if (this.quickCraftingType == 2) {
                this.quickCraftingRemainder = carriedStack.getMaxStackSize();
            } else {
                this.quickCraftingRemainder = carriedStack.getCount();
                for (Slot slot : this.quickCraftSlots) {
                    ItemStack slotStack = slot.getItem();
                    int slotStackCount = slotStack.isEmpty() ? 0 : slotStack.getCount();
                    int maxStackSize = slot.getMaxStackSize(carriedStack);
                    int quickCraftPlaceCount = Math.min(AbstractContainerMenu.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)this.quickCraftingType, (ItemStack)carriedStack) + slotStackCount, maxStackSize);
                    this.quickCraftingRemainder -= quickCraftPlaceCount - slotStackCount;
                }
            }
        }
    }

    private void renderErrorOverlay(GuiGraphics guiGraphics) {
        ((StorageContainerMenuBase)this.menu).getErrorUpgradeSlotChangeResult().ifPresent(upgradeSlotChangeResult -> upgradeSlotChangeResult.getErrorMessage().ifPresent(overlayErrorMessage -> {
            RenderSystem.disableDepthTest();
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            poseStack.translate((float)this.getGuiLeft(), (float)this.getGuiTop(), 0.0f);
            upgradeSlotChangeResult.getErrorUpgradeSlots().forEach(slotIndex -> {
                Slot upgradeSlot = ((StorageContainerMenuBase)this.menu).getSlot(((StorageContainerMenuBase)this.menu).getFirstUpgradeSlot() + slotIndex);
                StorageScreenBase.renderSlotHighlight((GuiGraphics)guiGraphics, (int)upgradeSlot.x, (int)upgradeSlot.y, (int)0, (int)ERROR_SLOT_COLOR);
            });
            upgradeSlotChangeResult.getErrorInventorySlots().forEach(slotIndex -> {
                Slot slot = ((StorageContainerMenuBase)this.menu).getSlot((int)slotIndex);
                if (slot != null) {
                    StorageScreenBase.renderSlotHighlight((GuiGraphics)guiGraphics, (int)slot.x, (int)slot.y, (int)0, (int)ERROR_SLOT_COLOR);
                }
            });
            upgradeSlotChangeResult.getErrorInventoryParts().forEach(partIndex -> {
                UpgradeInventoryPartBase<?> inventoryPart;
                if (this.inventoryParts.size() > partIndex && (inventoryPart = this.inventoryParts.get(partIndex)) != null) {
                    inventoryPart.renderErrorOverlay(guiGraphics);
                }
            });
            poseStack.popPose();
            this.renderErrorMessage(poseStack, (Component)overlayErrorMessage);
        }));
    }

    private void renderErrorMessage(PoseStack matrixStack, Component overlayErrorMessage) {
        matrixStack.pushPose();
        matrixStack.translate((double)((float)this.width / 2.0f), (double)this.topPos + (double)this.inventoryLabelY + 4.0, 300.0);
        Font fontrenderer = Minecraft.getInstance().font;
        int tooltipWidth = this.font.width((FormattedText)overlayErrorMessage);
        ArrayList<Object> wrappedTextLines = new ArrayList<Object>();
        int maxLineWidth = 260;
        if (tooltipWidth > maxLineWidth) {
            int wrappedTooltipWidth = 0;
            List wrappedLine = this.font.getSplitter().splitLines((FormattedText)overlayErrorMessage, maxLineWidth, Style.EMPTY);
            for (FormattedText line : wrappedLine) {
                int lineWidth = this.font.width(line);
                if (lineWidth > wrappedTooltipWidth) {
                    wrappedTooltipWidth = lineWidth;
                }
                wrappedTextLines.add(line);
            }
            tooltipWidth = wrappedTooltipWidth;
        } else {
            wrappedTextLines.add(overlayErrorMessage);
        }
        int tooltipHeight = 8;
        if (wrappedTextLines.size() > 1) {
            tooltipHeight += 2 + (wrappedTextLines.size() - 1) * 10;
        }
        Matrix4f matrix4f = matrixStack.last().pose();
        float leftX = (float)(-tooltipWidth) / 2.0f;
        GuiHelper.renderTooltipBackground(matrix4f, tooltipWidth, (int)leftX, 0, tooltipHeight, -267386864, ERROR_BORDER_COLOR, ERROR_BORDER_COLOR);
        MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        matrixStack.translate(0.0, 0.0, 400.0);
        GuiHelper.writeTooltipLines(wrappedTextLines, fontrenderer, leftX, 0, matrix4f, renderTypeBuffer, ERROR_TEXT_COLOR);
        renderTypeBuffer.endBatch();
        matrixStack.popPose();
    }

    @Override
    public void renderInventorySlots(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean canShowHover) {
        this.renderStorageInventorySlots(guiGraphics, mouseX, mouseY, canShowHover);
    }

    @Override
    public boolean isMouseOverSlot(Slot slot, double mouseX, double mouseY) {
        return this.isHovering(slot, mouseX, mouseY);
    }

    protected boolean isHovering(Slot slot, double mouseX, double mouseY) {
        return super.isHovering(slot, mouseX, mouseY) && this.getUpgradeSettingsControl().slotIsNotCoveredAt(slot, mouseX, mouseY);
    }

    @Override
    public int getTopY() {
        return this.getGuiTop();
    }

    @Override
    public void drawSlotBg(GuiGraphics guiGraphics) {
        this.drawSlotBg(guiGraphics, (this.width - this.imageWidth) / 2, (this.height - this.imageHeight) / 2);
        this.drawSlotOverlays(guiGraphics);
    }

    @Override
    public int getLeftX() {
        return this.getGuiLeft();
    }

    public Position getRightTopAbovePlayersInventory() {
        return new Position(this.storageBackgroundProperties.getPlayerInventoryXOffset() + 8 + 162, this.inventoryLabelY);
    }
}

