/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;

public class InventoryScrollPanel
extends ScrollPanel {
    private static final int TOP_Y_OFFSET = 1;
    private final IInventoryScreen screen;
    private final int firstSlotIndex;
    private final int numberOfSlots;
    private final int slotsInARow;

    public InventoryScrollPanel(Minecraft client, IInventoryScreen screen, int firstSlotIndex, int numberOfSlots, int slotsInARow, int height, int top, int left) {
        super(client, slotsInARow * 18 + 6, height, top, left, 0);
        this.screen = screen;
        this.firstSlotIndex = firstSlotIndex;
        this.numberOfSlots = numberOfSlots;
        this.slotsInARow = slotsInARow;
    }

    protected int getScrollAmount() {
        return 18;
    }

    protected int getContentHeight() {
        int rows = this.numberOfSlots / this.slotsInARow + (this.numberOfSlots % this.slotsInARow > 0 ? 1 : 0);
        return rows * 18;
    }

    protected void drawBackground(GuiGraphics guiGraphics, Tesselator tess, float partialTick) {
        this.screen.drawSlotBg(guiGraphics);
    }

    protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)this.screen.getLeftX(), (double)this.screen.getTopY(), 0.0);
        this.screen.renderInventorySlots(guiGraphics, mouseX, mouseY, this.isMouseOver(mouseX, mouseY));
        poseStack.popPose();
    }

    public Optional<Slot> findSlot(double mouseX, double mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return Optional.empty();
        }
        for (int slotIndex = this.firstSlotIndex; slotIndex < this.firstSlotIndex + this.numberOfSlots; ++slotIndex) {
            Slot slot = this.screen.getSlot(slotIndex);
            if (!this.screen.isMouseOverSlot(slot, mouseX, mouseY) || !slot.isActive()) continue;
            return Optional.of(slot);
        }
        return Optional.empty();
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean ret = super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        this.updateSlotsYPosition();
        return ret;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean ret = super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        this.updateSlotsYPosition();
        return ret;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        return false;
    }

    public void updateSlotsYPosition() {
        int i = this.firstSlotIndex;
        int row = 0;
        while (i < this.firstSlotIndex + this.numberOfSlots) {
            int newY = this.top - this.screen.getTopY() - (int)this.scrollDistance / 18 * 18 + row * 18 + 1;
            if (newY < -17 || newY > this.height) {
                newY = -100;
            }
            this.screen.getSlot((int)i).y = newY;
            row = ++i / this.slotsInARow;
        }
    }

    public static interface IInventoryScreen {
        public void renderInventorySlots(GuiGraphics var1, int var2, int var3, boolean var4);

        public boolean isMouseOverSlot(Slot var1, double var2, double var4);

        public void drawSlotBg(GuiGraphics var1);

        public int getTopY();

        public int getLeftX();

        public Slot getSlot(int var1);
    }
}

