/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;

public class TextBox
extends WidgetBase {
    private final EditBox editBox;

    public TextBox(Position position, Dimension dimension) {
        super(position, dimension);
        this.editBox = new EditBox(this.minecraft.font, position.x(), position.y(), dimension.width(), dimension.height(), (Component)Component.empty());
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        this.editBox.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        poseStack.popPose();
    }

    @Override
    public void setFocused(boolean focused) {
        if (this.editBox.isFocused() != focused) {
            this.editBox.setFocused(focused);
        }
        super.setFocused(focused);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.editBox.isFocused()) {
            return false;
        }
        this.editBox.keyPressed(keyCode, scanCode, modifiers);
        if (keyCode == 257) {
            this.onEnterPressed();
        }
        return keyCode != 256;
    }

    protected void onEnterPressed() {
    }

    public String getValue() {
        return this.editBox.getValue();
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.editBox.charTyped(codePoint, modifiers);
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
        this.editBox.updateNarration(narrationElementOutput);
    }

    public void setValue(String value) {
        this.editBox.setValue(value);
    }

    public void setTextColor(int color) {
        this.editBox.setTextColor(color);
    }

    public void setTextColorUneditable(int color) {
        this.editBox.setTextColorUneditable(color);
    }

    public void setBordered(boolean bordered) {
        this.editBox.setBordered(bordered);
    }

    public void setMaxLength(int maxLength) {
        this.editBox.setMaxLength(maxLength);
    }

    public void setResponder(Consumer<String> responder) {
        this.editBox.setResponder(responder);
    }

    public void setEditable(boolean editable) {
        this.editBox.setEditable(editable);
    }

    public boolean isEditable() {
        return this.editBox.isEditable();
    }
}

