/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHelper;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerStacksPacket;
import net.p3pp3rf1y.sophisticatedcore.network.SyncSlotStackPacket;

public class HighStackCountSynchronizer
implements ContainerSynchronizer {
    private final ServerPlayer player;

    public HighStackCountSynchronizer(ServerPlayer player) {
        this.player = player;
    }

    public void sendInitialData(AbstractContainerMenu containerMenu, NonNullList<ItemStack> stacks, ItemStack carriedStack, int[] dataSlots) {
        PacketHelper.sendToPlayer((CustomPacketPayload)new SyncContainerStacksPacket(containerMenu.containerId, containerMenu.incrementStateId(), (List<ItemStack>)stacks, carriedStack), this.player);
    }

    public void sendSlotChange(AbstractContainerMenu containerMenu, int slotInd, ItemStack stack) {
        PacketHelper.sendToPlayer((CustomPacketPayload)new SyncSlotStackPacket(containerMenu.containerId, containerMenu.incrementStateId(), slotInd, stack), this.player);
    }

    public void sendCarriedChange(AbstractContainerMenu containerMenu, ItemStack stack) {
        this.player.connection.send((Packet)new ClientboundContainerSetSlotPacket(-1, containerMenu.incrementStateId(), -1, stack));
    }

    public void sendDataChange(AbstractContainerMenu containerMenu, int slotInd, int data) {
    }
}

