/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.chipped;

import earth.terrarium.chipped.common.recipes.ChippedRecipe;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.compat.chipped.BlockTransformationUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class BlockTransformationUpgradeWrapper
extends UpgradeWrapperBase<BlockTransformationUpgradeWrapper, BlockTransformationUpgradeItem> {
    private static final String RESULT_TAG = "result";
    private final IItemHandlerModifiable inputInventory;
    private final RecipeType<ChippedRecipe> recipeType;

    protected BlockTransformationUpgradeWrapper(IStorageWrapper storageWrapper, final ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inputInventory = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (slot == 0) {
                    upgrade.addTagElement("input", (Tag)this.getStackInSlot(0).save(new CompoundTag()));
                }
                BlockTransformationUpgradeWrapper.this.save();
            }
        };
        NBTHelper.getCompound(upgrade, "input").ifPresent(tag -> this.inputInventory.setStackInSlot(0, ItemStack.of((CompoundTag)tag)));
        this.recipeType = ((BlockTransformationUpgradeItem)this.upgradeItem).getRecipeType();
    }

    public IItemHandlerModifiable getInputInventory() {
        return this.inputInventory;
    }

    public void setResult(ItemStack result) {
        if (result.isEmpty()) {
            NBTHelper.removeTag(this.upgrade, RESULT_TAG);
            return;
        }
        this.upgrade.getOrCreateTag().put(RESULT_TAG, (Tag)result.save(new CompoundTag()));
        this.save();
    }

    public Optional<ItemStack> getResult() {
        return NBTHelper.getCompound(this.upgrade, RESULT_TAG).map(ItemStack::of);
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    public boolean shouldShiftClickIntoStorage() {
        return NBTHelper.getBoolean(this.upgrade, "shiftClickIntoStorage").orElse(true);
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        NBTHelper.setBoolean(this.upgrade, "shiftClickIntoStorage", shiftClickIntoStorage);
        this.save();
    }

    public RecipeType<ChippedRecipe> getRecipeType() {
        return this.recipeType;
    }
}

