/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;

public class SetGhostSlotMessage
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "set_ghost_slot");
    private final ItemStack stack;
    private final int slotNumber;

    public SetGhostSlotMessage(ItemStack stack, int slotNumber) {
        this.stack = stack;
        this.slotNumber = slotNumber;
    }

    public SetGhostSlotMessage(FriendlyByteBuf buffer) {
        this(buffer.readItem(), buffer.readShort());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        if (!(player.containerMenu instanceof StorageContainerMenuBase)) {
            return;
        }
        player.containerMenu.getSlot(this.slotNumber).set(this.stack);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeItem(this.stack);
        buffer.writeShort(this.slotNumber);
    }

    public ResourceLocation id() {
        return ID;
    }
}

