/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;

public class SetMemorySlotMessage
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "set_memory_slot");
    private final ItemStack stack;
    private final int slotNumber;

    public SetMemorySlotMessage(ItemStack stack, int slotNumber) {
        this.stack = stack;
        this.slotNumber = slotNumber;
    }

    public SetMemorySlotMessage(FriendlyByteBuf buffer) {
        this(buffer.readItem(), buffer.readShort());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof SettingsContainerMenu)) {
            return;
        }
        SettingsContainerMenu settingsContainerMenu = (SettingsContainerMenu)abstractContainerMenu;
        Object storageWrapper = settingsContainerMenu.getStorageWrapper();
        storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).setFilter(this.slotNumber, this.stack);
        storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).itemChanged(this.slotNumber);
        storageWrapper.getInventoryHandler().onSlotFilterChanged(this.slotNumber);
        settingsContainerMenu.sendAdditionalSlotInfo();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeItem(this.stack);
        buffer.writeShort(this.slotNumber);
    }

    public ResourceLocation id() {
        return ID;
    }
}

