/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.compat.jei.CraftingContainerRecipeTransferHandlerServer;

public class TransferRecipeMessage
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "transfer_recipe");
    private final Map<Integer, Integer> matchingItems;
    private final List<Integer> craftingSlotIndexes;
    private final List<Integer> inventorySlotIndexes;
    private final boolean maxTransfer;
    private final ResourceLocation recipeId;

    public TransferRecipeMessage(ResourceLocation recipeId, Map<Integer, Integer> matchingItems, List<Integer> craftingSlotIndexes, List<Integer> inventorySlotIndexes, boolean maxTransfer) {
        this.recipeId = recipeId;
        this.matchingItems = matchingItems;
        this.craftingSlotIndexes = craftingSlotIndexes;
        this.inventorySlotIndexes = inventorySlotIndexes;
        this.maxTransfer = maxTransfer;
    }

    public TransferRecipeMessage(FriendlyByteBuf buffer) {
        this(buffer.readResourceLocation(), buffer.readMap(FriendlyByteBuf::readInt, FriendlyByteBuf::readInt), (List)buffer.readCollection(ArrayList::new, FriendlyByteBuf::readInt), (List)buffer.readCollection(ArrayList::new, FriendlyByteBuf::readInt), buffer.readBoolean());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        CraftingContainerRecipeTransferHandlerServer.setItems(player, this.recipeId, this.matchingItems, this.craftingSlotIndexes, this.inventorySlotIndexes, this.maxTransfer);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.recipeId);
        buffer.writeMap(this.matchingItems, FriendlyByteBuf::writeInt, FriendlyByteBuf::writeInt);
        buffer.writeCollection(this.craftingSlotIndexes, FriendlyByteBuf::writeInt);
        buffer.writeCollection(this.inventorySlotIndexes, FriendlyByteBuf::writeInt);
        buffer.writeBoolean(this.maxTransfer);
    }

    public ResourceLocation id() {
        return ID;
    }
}

