/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.crafting;

import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedcore.init.ModRecipes;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;

public class UpgradeNextTierRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    private final ShapedRecipe compose;

    public UpgradeNextTierRecipe(ShapedRecipe compose) {
        super(compose.getGroup(), compose.category(), compose.pattern, compose.result);
        this.compose = compose;
    }

    @Override
    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack nextTier = super.assemble(inv, registryAccess);
        this.getUpgrade(inv).ifPresent(upgrade -> nextTier.setTag(upgrade.getTag()));
        return nextTier;
    }

    private Optional<ItemStack> getUpgrade(CraftingContainer inv) {
        for (int slot = 0; slot < inv.getContainerSize(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            if (!(slotStack.getItem() instanceof IUpgradeItem)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.UPGRADE_NEXT_TIER_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, UpgradeNextTierRecipe> {
        public Serializer() {
            super(UpgradeNextTierRecipe::new, RecipeSerializer.SHAPED_RECIPE);
        }
    }
}

