/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.init;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ModFluids {
    public static final ResourceLocation EXPERIENCE_TAG_NAME = new ResourceLocation("forge:experience");
    public static final TagKey<Fluid> EXPERIENCE_TAG = TagKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)EXPERIENCE_TAG_NAME);
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"sophisticatedcore");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"sophisticatedcore");
    public static final Supplier<FlowingFluid> XP_STILL = FLUIDS.register("xp_still", () -> new BaseFlowingFluid.Source(ModFluids.fluidProperties()));
    public static final Supplier<FlowingFluid> XP_FLOWING = FLUIDS.register("xp_flowing", () -> new BaseFlowingFluid.Flowing(ModFluids.fluidProperties()));
    public static final Supplier<FluidType> XP_FLUID_TYPE = FLUID_TYPES.register("experience", () -> new FluidType(FluidType.Properties.create().lightLevel(10).density(800).viscosity(1500)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation XP_STILL_TEXTURE = new ResourceLocation("sophisticatedcore", "block/xp_still");
                private static final ResourceLocation XP_FLOWING_TEXTURE = new ResourceLocation("sophisticatedcore", "block/xp_flowing");

                public ResourceLocation getStillTexture() {
                    return XP_STILL_TEXTURE;
                }

                public ResourceLocation getFlowingTexture() {
                    return XP_FLOWING_TEXTURE;
                }
            });
        }
    });

    private ModFluids() {
    }

    private static BaseFlowingFluid.Properties fluidProperties() {
        return new BaseFlowingFluid.Properties(XP_FLUID_TYPE, XP_STILL, XP_FLOWING);
    }

    public static void registerHandlers(IEventBus modBus) {
        FLUIDS.register(modBus);
        FLUID_TYPES.register(modBus);
    }
}

