/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.TickEvent;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;

public final class ItemStackKey {
    private static final Field ATTACHMENTS = ObfuscationReflectionHelper.findField(AttachmentHolder.class, (String)"attachments");
    private final ItemStack stack;
    private static final Map<ItemStack, ItemStackKey> CACHE = new ConcurrentHashMap<ItemStack, ItemStackKey>();
    private boolean hashInitialized = false;
    private int hash;

    public static ItemStackKey of(ItemStack stack) {
        return CACHE.computeIfAbsent(stack, ItemStackKey::new);
    }

    private ItemStackKey(ItemStack stack) {
        this.stack = stack.copy();
        this.stack.setCount(1);
    }

    public static void clearCacheOnTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        CACHE.clear();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStackKey that = (ItemStackKey)o;
        return ItemStackKey.canItemStacksStack(this.stack, that.stack);
    }

    public static boolean canItemStacksStack(ItemStack a, ItemStack b) {
        if (a.isEmpty() || a.getItem() != b.getItem() || a.hasTag() != b.hasTag()) {
            return false;
        }
        return (!a.hasTag() || a.getTag().equals((Object)b.getTag())) && a.areAttachmentsCompatible(b);
    }

    public boolean hashCodeNotEquals(ItemStack otherStack) {
        return this.hashCode() != ItemStackKey.getHashCode(otherStack);
    }

    public int hashCode() {
        if (!this.hashInitialized) {
            this.hashInitialized = true;
            this.hash = ItemStackKey.getHashCode(this.stack);
        }
        return this.hash;
    }

    public static int getHashCode(ItemStack stack) {
        Map<AttachmentType<?>, Object> attachments;
        int hash = stack.getItem().hashCode();
        if (stack.hasTag()) {
            hash = hash * 31 + stack.getTag().hashCode();
        }
        if (stack.hasAttachments() && (attachments = ItemStackKey.getAttachments(stack)) != null) {
            hash = hash * 31 + attachments.hashCode();
        }
        return hash;
    }

    @Nullable
    private static Map<AttachmentType<?>, Object> getAttachments(ItemStack stack) {
        try {
            return (Map)ATTACHMENTS.get(stack);
        }
        catch (IllegalAccessException e) {
            SophisticatedCore.LOGGER.error("Error getting attachments of stack ", (Throwable)e);
            return null;
        }
    }

    public boolean matches(ItemStack stack) {
        return this.hashCode() == ItemStackKey.getHashCode(stack);
    }

    public ItemStack stack() {
        return this.stack;
    }

    public String toString() {
        return "ItemStackKey[stack=" + this.stack + "]";
    }
}

