/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IAdditionalSlotInfoMenu;

public class SyncAdditionalSlotInfoPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "sync_additional_slot_info");
    private final Set<Integer> inaccessibleSlots;
    private final Map<Integer, Integer> slotLimitOverrides;
    private final Map<Integer, Item> slotFilterItems;

    public SyncAdditionalSlotInfoPacket(Set<Integer> inaccessibleSlots, Map<Integer, Integer> slotLimitOverrides, Map<Integer, Item> slotFilterItems) {
        this.inaccessibleSlots = inaccessibleSlots;
        this.slotLimitOverrides = slotLimitOverrides;
        this.slotFilterItems = slotFilterItems;
    }

    public SyncAdditionalSlotInfoPacket(FriendlyByteBuf buffer) {
        this(Arrays.stream(buffer.readVarIntArray()).boxed().collect(Collectors.toSet()), SyncAdditionalSlotInfoPacket.deserializeSlotLimitOverrides(buffer), SyncAdditionalSlotInfoPacket.deserializeSlotFilterItems(buffer));
    }

    private static Map<Integer, Item> deserializeSlotFilterItems(FriendlyByteBuf buffer) {
        HashMap<Integer, Item> ret = new HashMap<Integer, Item>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ret.put(buffer.readInt(), Item.byId((int)buffer.readInt()));
        }
        return ret;
    }

    private void serializeSlotFilterItems(FriendlyByteBuf buffer, Map<Integer, Item> slotFilterItems) {
        buffer.writeInt(slotFilterItems.size());
        slotFilterItems.forEach((slot, item) -> {
            buffer.writeInt(slot.intValue());
            buffer.writeInt(Item.getId((Item)item));
        });
    }

    private static Map<Integer, Integer> deserializeSlotLimitOverrides(FriendlyByteBuf buffer) {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            ret.put(buffer.readInt(), buffer.readInt());
        }
        return ret;
    }

    private void serializeSlotLimitOverrides(FriendlyByteBuf buffer, Map<Integer, Integer> slotLimitOverrides) {
        buffer.writeInt(slotLimitOverrides.size());
        slotLimitOverrides.forEach((slot, limit) -> {
            buffer.writeInt(slot.intValue());
            buffer.writeInt(limit.intValue());
        });
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof IAdditionalSlotInfoMenu)) {
            return;
        }
        IAdditionalSlotInfoMenu menu = (IAdditionalSlotInfoMenu)abstractContainerMenu;
        menu.updateAdditionalSlotInfo(this.inaccessibleSlots, this.slotLimitOverrides, this.slotFilterItems);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarIntArray(this.inaccessibleSlots.stream().mapToInt(i -> i).toArray());
        this.serializeSlotLimitOverrides(buffer, this.slotLimitOverrides);
        this.serializeSlotFilterItems(buffer, this.slotFilterItems);
    }

    public ResourceLocation id() {
        return ID;
    }
}

