/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;

public class SyncContainerClientDataPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "sync_container_client_data");
    @Nullable
    private final CompoundTag data;

    public SyncContainerClientDataPacket(@Nullable CompoundTag data) {
        this.data = data;
    }

    public SyncContainerClientDataPacket(FriendlyByteBuf buffer) {
        this(buffer.readNbt());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        if (this.data == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ISyncedContainer) {
            ISyncedContainer container = (ISyncedContainer)abstractContainerMenu;
            container.handlePacket(this.data);
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeNbt((Tag)this.data);
    }

    public ResourceLocation id() {
        return ID;
    }
}

