/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHelper;

public class SyncContainerStacksPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "sync_container_stacks");
    private final int windowId;
    private final int stateId;
    private final List<ItemStack> itemStacks;
    private final ItemStack carriedStack;

    public SyncContainerStacksPacket(int windowId, int stateId, List<ItemStack> itemStacks, ItemStack carriedStack) {
        this.windowId = windowId;
        this.stateId = stateId;
        this.itemStacks = itemStacks;
        this.carriedStack = carriedStack;
    }

    public SyncContainerStacksPacket(FriendlyByteBuf buffer) {
        this(buffer.readUnsignedByte(), buffer.readVarInt(), (List)buffer.readCollection(ArrayList::new, PacketHelper::readOversizedItemStack), buffer.readItem());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        if (!(player.containerMenu instanceof StorageContainerMenuBase) || player.containerMenu.containerId != this.windowId) {
            return;
        }
        player.containerMenu.initializeContents(this.stateId, this.itemStacks, this.carriedStack);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.windowId);
        buffer.writeVarInt(this.stateId);
        buffer.writeCollection(this.itemStacks, (buf, itemStack) -> PacketHelper.writeOversizedItemStack(itemStack, buf));
        buffer.writeItem(this.carriedStack);
    }

    public ResourceLocation id() {
        return ID;
    }
}

