/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.DatapackSettingsTemplateManager;

public class SyncDatapackSettingsTemplatePacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "sync_datapack_settings_template");
    private final String datapack;
    private final String templateName;
    private final CompoundTag settingsNbt;

    public SyncDatapackSettingsTemplatePacket(String datapack, String templateName, @Nullable CompoundTag settingsNbt) {
        this.datapack = datapack;
        this.templateName = templateName;
        this.settingsNbt = settingsNbt;
    }

    public SyncDatapackSettingsTemplatePacket(FriendlyByteBuf buffer) {
        this(buffer.readUtf(), buffer.readUtf(), buffer.readNbt());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        if (this.settingsNbt == null) {
            return;
        }
        DatapackSettingsTemplateManager.putTemplate(this.datapack, this.templateName, this.settingsNbt);
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof SettingsContainerMenu) {
            SettingsContainerMenu settingsContainerMenu = (SettingsContainerMenu)abstractContainerMenu;
            settingsContainerMenu.refreshTemplateSlots();
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.datapack);
        buffer.writeUtf(this.templateName);
        buffer.writeNbt((Tag)this.settingsNbt);
    }

    public ResourceLocation id() {
        return ID;
    }
}

