/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;

public class SyncPlayerSettingsPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "sync_player_settings");
    private final String playerTagName;
    @Nullable
    private final CompoundTag settingsNbt;

    public SyncPlayerSettingsPacket(String playerTagName, @Nullable CompoundTag settingsNbt) {
        this.playerTagName = playerTagName;
        this.settingsNbt = settingsNbt;
    }

    public SyncPlayerSettingsPacket(FriendlyByteBuf buffer) {
        this(buffer.readUtf(), buffer.readNbt());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        if (this.settingsNbt == null) {
            return;
        }
        SettingsManager.setPlayerSettingsTag(player, this.playerTagName, this.settingsNbt);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.playerTagName);
        buffer.writeNbt((Tag)this.settingsNbt);
    }

    public ResourceLocation id() {
        return ID;
    }
}

