/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHelper;

public class SyncSlotStackPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "sync_slot_stack");
    private final int windowId;
    private final int stateId;
    private final int slotNumber;
    private final ItemStack stack;

    public SyncSlotStackPacket(int windowId, int stateId, int slotNumber, ItemStack stack) {
        this.windowId = windowId;
        this.stateId = stateId;
        this.slotNumber = slotNumber;
        this.stack = stack;
    }

    public SyncSlotStackPacket(FriendlyByteBuf buffer) {
        this(buffer.readUnsignedByte(), buffer.readVarInt(), buffer.readShort(), PacketHelper.readOversizedItemStack(buffer));
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        if (!(player.containerMenu instanceof StorageContainerMenuBase) && !(player.containerMenu instanceof SettingsContainerMenu) || player.containerMenu.containerId != this.windowId) {
            return;
        }
        player.containerMenu.setItem(this.slotNumber, this.stateId, this.stack);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.windowId);
        buffer.writeVarInt(this.stateId);
        buffer.writeShort(this.slotNumber);
        PacketHelper.writeOversizedItemStack(this.stack, buffer);
    }

    public ResourceLocation id() {
        return ID;
    }
}

