/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTemplateStorage;

public class SyncTemplateSettingsPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "sync_template_settings");
    private final Map<Integer, CompoundTag> playerTemplates;
    private final Map<String, CompoundTag> playerNamedTemplates;

    public SyncTemplateSettingsPacket(Map<Integer, CompoundTag> playerTemplates, Map<String, CompoundTag> playerNamedTemplates) {
        this.playerTemplates = playerTemplates;
        this.playerNamedTemplates = playerNamedTemplates;
    }

    public SyncTemplateSettingsPacket(FriendlyByteBuf buffer) {
        this(buffer.readMap(FriendlyByteBuf::readInt, b -> b.readNbt()), buffer.readMap(FriendlyByteBuf::readUtf, b -> b.readNbt()));
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        SettingsTemplateStorage settingsTemplateStorage = SettingsTemplateStorage.get();
        settingsTemplateStorage.clearPlayerTemplates(player);
        this.playerTemplates.forEach((k, v) -> settingsTemplateStorage.putPlayerTemplate(player, (int)k, (CompoundTag)v));
        this.playerNamedTemplates.forEach((k, v) -> settingsTemplateStorage.putPlayerNamedTemplate(player, (String)k, (CompoundTag)v));
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof SettingsContainerMenu) {
            SettingsContainerMenu settingsContainerMenu = (SettingsContainerMenu)abstractContainerMenu;
            settingsContainerMenu.refreshTemplateSlots();
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeMap(this.playerTemplates, FriendlyByteBuf::writeInt, FriendlyByteBuf::writeNbt);
        buffer.writeMap(this.playerNamedTemplates, FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeNbt);
    }

    public ResourceLocation id() {
        return ID;
    }
}

