/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;

public class TransferFullSlotPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("sophisticatedcore", "transfer_full_slot");
    private final int slotId;

    public TransferFullSlotPacket(int slotId) {
        this.slotId = slotId;
    }

    public TransferFullSlotPacket(FriendlyByteBuf buffer) {
        this(buffer.readInt());
    }

    public void handle(PlayPayloadContext context) {
        context.workHandler().execute(() -> context.player().ifPresent(this::handlePacket));
    }

    private void handlePacket(Player player) {
        ItemStack transferResult;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase storageContainer = (StorageContainerMenuBase)abstractContainerMenu;
        Slot slot = storageContainer.getSlot(this.slotId);
        while (!(transferResult = storageContainer.quickMoveStack(player, this.slotId)).isEmpty() && ItemStack.isSameItem((ItemStack)slot.getItem(), (ItemStack)transferResult)) {
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slotId);
    }

    public ResourceLocation id() {
        return ID;
    }
}

